@extends('crm-admin::main-layout')

@section('content')
<div class='row'>
  <div class='col-md-12 collapse' id='agregarCategoria'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Agregar campos extras
          <span></span>
          <a aria-expanded='false' class='btn btn-xs btn-danger button-ml' data-toggle='collapse' href='#agregarCategoria'>
            Cancelar
          </a>
        </h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          {!! Form::open(['route'=> 'admin.shop.extra-fields.store','method'=>'POST', 'enctype'=>'multipart/form-data']) !!}
          @include('shop::extra.fields')
          <div class='form-group'>
            <button class='btn btn-primary' type='submit'>
              Registrar
            </button>
          </div>
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>
  <div class='col-md-12'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Listado de campos extras
          <span>
            <a aria-expanded='false' class='btn btn-xs btn-info button-ml' data-toggle='collapse' href='#agregarCategoria'>
              <i class='fas fa-plus'></i>
              Agregar campos extras
            </a>
          </span>
        </h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          <table class='table'>
            <tr>
              <th>#</th>
              <th>Informacion</th>
              <th>Valores</th>
              <th></th>
            </tr>
            @foreach ($extras as $extra)
            <tr>
              <td> {{$extra->id}}</td>
              <td>
                Variable: <b>{{$extra->variable}}</b><br>
                Etiqueta: <b>{{$extra->alias}}</b><br>
                Tipo: <b>{{$extra->type}}</b><br>
                Estatus: <b>{{$extra->active ? "Activo" : "Inactivo"}}</b>
              </td>
              <td> Opciones: <br><b>{{$extra->values != null ? $extra->values : "No aplica"}}</b></td>
              <td>
                {!! Form::open(['route'=> ['admin.shop.extra-fields.destroy',$extra->id],'method'=>'DELETE'])!!}
                <button class='btn btn-danger btn-xs button-mb' onclick="return confirm('¿Estás seguro de eliminar este elemento?');" type='submit'>
                  <i class='fas fa-trash-alt icon-special-size'></i>
                  Eliminar
                </button>
                {!! Form::close()!!}
                <a class='btn btn-xs accent' href="{{route('admin.shop.extra-fields.edit', $extra->id)}}">
                  <i class='fas fa-edit icon-special-size'></i>
                  Editar
                </a>
              </td>
              @endforeach
            </tr>
          </table>
        </div>
      </div>
      <div class='dker p-a text-right'>
        {{ $extras->links() }}
      </div>
    </div>
  </div>
</div>
@endsection
