@extends('shop-public::layout')
@section('pageTitle', 'Finalizar compra')
@section('content')

@php
setlocale(LC_MONETARY, 'en_US');
@endphp

<code>
	Variables disponibles:
	<ul>
		<li>$sale</li>
		<li>$client</li>
		<li>$items</li>
		<li>$addres</li>
	</ul>
</code>

<section>

	<h4>Detalle del pedido <span><a href="{{route('cart.cancel')}}">Modificar mi carrito de compras</a></span></h4>
	<table class="table" style="width: 60%;">
		<thead>
			<tr>
				<th>Producto</th>
				<th>Precio</th>
				<th>Cantidad</th>
				<th>Subtotal</th>
				<th></th>
			</tr>
		</thead>
		@foreach($items as $item)
		<tbody>
			<tr align="center">
				<td>{{$item->product->name}}</td>
				<td>{{money_format('%(#10n', $item->product->infoSale->sale_price)}}</td>
				<td>{{$item->quantity}}</td>
				<td>
					{{money_format('%(#10n', ($item->product->infoSale->sale_price * $item->quantity))}}
				</td>
			</tr>
		</tbody>
		@endforeach
		<tr>
			<td colspan="3" align="right">
				Total + Envio: 
			</td>
			<td align="center">
				{{ money_format('%(#10n', ($total)) }} + 
				{{ money_format('%(#10n', $addres->shipping_price->cost) }} =
				{{ money_format('%(#10n', ($total + $addres->shipping_price->cost)) }}
			</td>
		</tr>
	</table>
</section>

<section>
	<h4>Formulario de pago</h4>

	@include('shop-public::forms.fields-payment')

	<br>

	@include('shop-public::forms.fields-payment-cash')

	<br>
	@include('shop-public::forms.form-paypal')
	<br>


</section>

@endsection

@section('scripts_extra')
	<script type="text/javascript">

		Mercadopago.setPublishableKey({{env('PK_MERCADO_PAGO')}});



		$("#form-pagar-mp").submit(function( event ) {

		    $('.btn-submit').attr('disabled', 'disabled');

		    swal({
		        text: "Espera por favor, estamos enviando tu pago...",
		        imageUrl: "/assets/img/ripple.gif",
		        showConfirmButton: false,
		        allowEscapeKey: false,
		        allowOutsideClick: false,
		        closeOnConfirm: false,
		        closeOnCancel: false
		      });

		    var $form = $(this);
		    Mercadopago.createToken($form, mpResponseHandler);
		    event.preventDefault();
		    return false;
		});



		 var mpResponseHandler = function(status, response) {
		    var $form = $('#form-pagar-mp');
		    
		    if (response.error) {
		        alert("ocurri&oacute; un error: "+JSON.stringify(response));
		        console.log(response);
		        swal.close();
		        var error = '<div class="alert alert-dismissable alert-danger">'+
		        '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
		        'Haz ingresado valores invalidos: <br>Revisa los datos capturados o intenta con otra tarjeta'+
		        '</div>';
		        $("#errors-card").html(error);
		        $('.btn-submit').removeAttr('disabled');
		    } else {
		        var card_token_id = response.id;
		        $form.append($('<input type="hidden" id="card_token_id" name="card_token_id"/>').val(card_token_id));
		        //alert("card_token_id: "+card_token_id);
		        $("#errors-card").html("");
		        $form.get(0).submit();
		    }
		}




		function addEvent(el, eventName, handler){
			if (el.addEventListener) {
				el.addEventListener(eventName, handler);
			} else {
				el.attachEvent('on' + eventName, function(){
					handler.call(el);
				});
			}
		};

		function getBin() {
			var ccNumber = document.querySelector('input[data-checkout="cardNumber"]');
			return ccNumber.value.replace(/[ .-]/g, '').slice(0, 6);
		};

		function guessingPaymentMethod(event) {
			var bin = getBin();

			if (event.type == "keyup") {
				if (bin.length >= 6) {
					Mercadopago.getPaymentMethod({
						"bin": bin
					}, setPaymentMethodInfo);
				}
			} else {
				setTimeout(function() {
					if (bin.length >= 6) {
						Mercadopago.getPaymentMethod({
							"bin": bin
						}, setPaymentMethodInfo);
					}
				}, 100);
			}
		};

		function setPaymentMethodInfo(status, response) {
			console.log("holiholi");
			if (status == 200) {
			    // do somethings ex: show logo of the payment method
			    var form = document.querySelector('#form-pagar-mp');

			    if (document.querySelector("input[name=paymentMethodId]") == null) {
			    	var paymentMethod = document.createElement('input');
			    	paymentMethod.setAttribute('name', "paymentMethodId");
			    	paymentMethod.setAttribute('type', "hidden");
			    	paymentMethod.setAttribute('value', response[0].id);

			    	form.appendChild(paymentMethod);
			    } else {
			    	document.querySelector("input[name=paymentMethodId]").value = response[0].id;
			    }
		    }
		};

		addEvent(document.querySelector('input[data-checkout="cardNumber"]'), 'keyup', guessingPaymentMethod);
		addEvent(document.querySelector('input[data-checkout="cardNumber"]'), 'change', guessingPaymentMethod);

</script>
@endsection