@extends('shop-public::layout')
@section('pageTitle', 'Finalizar compra')
@section('content')
@php
setlocale(LC_MONETARY, 'en_US');
@endphp
<code>
	Variables disponibles:
	<ul>
		<li>$shipping</li>
		<li>$total</li>
		<li>$cart</li>
	</ul>
</code>

<section>
	<h4>Detalles del pedido</h4>
	<table class="table" style="width: 60%;">
		<thead>
			<tr>
				<th>Producto</th>
				<th>Precio</th>
				<th>Cantidad</th>
				<th>Subtotal</th>
				<th></th>
			</tr>
		</thead>
		@foreach($cart as $product)
		<tbody>
			<tr align="center">
				<td>{{$product->name}}</td>
				<td>{{money_format('%(#10n', $product->infoSale->sale_price)}}</td>
				<td>{{$product->quantity}}</td>
				<td>
					{{money_format('%(#10n', ($product->infoSale->sale_price * $product->quantity))}}
				</td>
			</tr>
		</tbody>
		@endforeach
		<tr>
			<td colspan="3" align="right">
				Total: 
			</td>
			<td align="center">
				{{money_format('%(#10n', ($total))}}
			</td>
		</tr>
	</table>
</section>

<section>
	<h4>Datos del comprador</h4>
	{!! Form::model($client, ['route'=>'cart.store.client','method'=>'POST']) !!}
		@include('shop-public::forms.fields-client')
</section>

<section>
	<h4>Datos de envio</h4>
		@include('shop-public::forms.fields-shipping')

	<br>
	{!! Form::submit('Enviar información', ['class'=>'']) !!}
	{!! Form::close() !!}
	
</section>




@endsection

@section('scripts_extra')

@endsection