<!DOCTYPE html>
<html>
<head>
	<title>
		@yield('pageTitle', '')
	</title>
	@include('shop-public::metatags')
</head>
<body>
	<p>
		<a href="{{route('cart.show')}}">Ver carrito 
			<span>{{\Session::has('cart') ? count(\Session::get('cart')) : 0}}</span>
		</a>
	</p>
	{{-- Aqui toda la estructura del blog--}}

	@yield('content')

	{{-- Aqui el footer --}}

<!-- Importante: scripts elementales no remover -->
<script src='https://unpkg.com/sweetalert/dist/sweetalert.min.js'></script>
<script
  src="https://code.jquery.com/jquery-3.3.1.min.js"
  integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="
  crossorigin="anonymous"></script>

<script src="https://secure.mlstatic.com/sdk/javascript/v1/mercadopago.js"></script>

{{-- Mensajes de alerta de pagos --}}

@if(Session::has('payment_approved'))
	<script type="text/javascript">
		swal("Gracias por tu compra", "El pago ha sido aceptado, revisa tu correo", "success")
	</script>
@endif

@if(Session::has('payment_reject'))
	<script type="text/javascript">
		swal("Pago rechazado", "Tuvimos problemas para procesar tu pago, verifica tus datos o intenta con otra tarjeta", "error")
	</script>
@endif

@if(Session::has('payment_pending'))
	<script type="text/javascript">
		swal("Pago pendiente", "Estamos procesando tu pago, te notificaremos por correo el estatus", "warning")
	</script>
@endif

@if(Session::has('paypal_cancel'))
	<script type="text/javascript">
		swal("Operación cancelada", "Se cancelo el proceso de pago", "warning")
	</script>
@endif


@if(Session::has('url_ficha'))
	<script>

		$(function() {
			var url = "{{Session::get('url_ficha')}}";
			swal("Pago pendiente", "Descarga tu ficha y llevala a pagar al lugar correspodiente", "warning")
			console.log(url);
			window.open(url, '_blank');
		})

	</script>
@endif


<!-- ******************************************* -->


@yield('scripts_extra')


</body>
</html>