# Package shop OneStartup

  **onestartup/shop** is a module e-commerce

# Installation

- Run this in the terminal

```php
composer require onestartup/shop
```

- if wish config payments paypal, run this:

```
composer require paypal/rest-api-sdk-php:*
```

- after add the ServiceProvider to the providers array in config/app.php

```php
Onestartup\Shop\ShopServiceProvider::class,
```

- Run migration

```php
php artisan migrate
```

- add next lines to app/User.php

```php
public function productsShop()
{
    return $this->hasMany('Onestartup\Shop\Model\ProductShop', 'user_id');
}
```

- run command for publish views

```php
php artisan vendor:publish --provider="Onestartup\Shop\ShopServiceProvider"
```

- run serv

```php
php artisan serve
```

- test in this route how admin user

```php
http://localhost:8000/admin/shop/product
```

- test in this route 

```php
http://localhost:8000/productos
```

- add to .env file de keys

```
PK_MERCADO_PAGO=Public key
AC_MERCADO_PAGO=Access token

CLIENT_ID_PAYPAL=cliente id
SECRET_PAYPAL=secret id
PAYPAL_MODE=sandbox
```

- for the search

```
composer require laravel/scout
composer require algolia/algoliasearch-client-php

php artisan vendor:publish --provider="Laravel\Scout\ScoutServiceProvider"
```

- env vars
```
ALGOLIA_APP_ID=YourApplicationID
ALGOLIA_SECRET=YourAdminAPIKey
ALGOLIA_SEARCH=YourSearchOnlyAPIKey
SCOUT_QUEUE=true
```

- run
```
php artisan scout:import 'Onestartup\Shop\Model\ProductShop'
```

# Facturacion

Agregar al archivo database/seeds/DatabaseSeeder.php

```
	$this->call(CreateUsoCfdiCatalog::class);
    $this->call(CreateUnidadesSeed::class);
    $this->call(CreateClavesProductosSeed::class);
```

Correr migraciones y seeders

```
	php artisan migrate --seed
```







