<?php

namespace Onestartup\Shop;

use Illuminate\Support\ServiceProvider;

class ShopServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        include __DIR__.'/routes.php';
        $this->loadMigrationsFrom(__DIR__.'/migrations');


        if (is_dir(base_path() . '/resources/views/vendor/onestartup/shop')) {

            $this->loadViewsFrom(base_path() . '/resources/views/vendor/onestartup/shop', 'shop-public');
            $this->loadViewsFrom(__DIR__.'/views', 'shop');

        } else {
           
            $this->loadViewsFrom(__DIR__.'/views', 'shop');
            $this->loadViewsFrom(__DIR__.'/views/public', 'shop-public');
        }

        $this->publishes([
            __DIR__.'/views/public' => resource_path('views/vendor/onestartup/shop'),
        ]);

        $this->publishes([
            __DIR__.'/assets' => public_path('vendor/onestartup/shop'),
        ], 'public');



    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->make('Onestartup\Shop\Controller\AdminProductController');
        $this->app->make('Onestartup\Shop\Controller\CategoryController');
        $this->app->make('Onestartup\Shop\Controller\ProductController');
        $this->app->make('Onestartup\Shop\Controller\CartController');
        $this->app->make('Onestartup\Shop\Controller\ShippingPriceController');
        $this->app->make('Onestartup\Shop\Controller\ExtraFieldController');
    }
}
