	Mercadopago.setPublishableKey('TEST-73a8fe53-17bf-4060-b2b8-a069cc779a11');
	$("#form-pagar-mp").submit(function( event ) {

		$('.btn-submit').attr('disabled', 'disabled');

		swal({
			text: "Espera por favor, estamos enviando tu pago...",
			imageUrl: "/assets/img/ripple.gif",
			showConfirmButton: false,
			allowEscapeKey: false,
			allowOutsideClick: false,
			closeOnConfirm: false,
			closeOnCancel: false
		});

		var $form = $(this);
		Mercadopago.createToken($form, mpResponseHandler);
		event.preventDefault();
		return false;
	});



	var mpResponseHandler = function(status, response) {
		var $form = $('#form-pagar-mp');

		if (response.error) {
			alert("ocurri&oacute; un error: "+JSON.stringify(response));
			console.log(response);
			swal.close();
			var error = '<div class="alert alert-dismissable alert-danger">'+
			'<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
			'Haz ingresado valores invalidos: <br>Revisa los datos capturados o intenta con otra tarjeta'+
			'</div>';
			$("#errors-card").html(error);
			$('.btn-submit').removeAttr('disabled');
		} else {
			var card_token_id = response.id;
			$form.append($('<input type="hidden" id="card_token_id" name="card_token_id"/>').val(card_token_id));
		        //alert("card_token_id: "+card_token_id);
		        $("#errors-card").html("");
		        $form.get(0).submit();
		    }
		}




		function addEvent(el, eventName, handler){
			if (el.addEventListener) {
				el.addEventListener(eventName, handler);
			} else {
				el.attachEvent('on' + eventName, function(){
					handler.call(el);
				});
			}
		};

		function getBin() {
			var ccNumber = document.querySelector('input[data-checkout="cardNumber"]');
			return ccNumber.value.replace(/[ .-]/g, '').slice(0, 6);
		};

		function guessingPaymentMethod(event) {
			var bin = getBin();

			if (event.type == "keyup") {
				if (bin.length >= 6) {
					Mercadopago.getPaymentMethod({
						"bin": bin
					}, setPaymentMethodInfo);
				}
			} else {
				setTimeout(function() {
					if (bin.length >= 6) {
						Mercadopago.getPaymentMethod({
							"bin": bin
						}, setPaymentMethodInfo);
					}
				}, 100);
			}
		};

		function setPaymentMethodInfo(status, response) {
			
			if (status == 200) {
			    // do somethings ex: show logo of the payment method
			    var form = document.querySelector('#form-pagar-mp');

			    if (document.querySelector("input[name=paymentMethodId]") == null) {
			    	var paymentMethod = document.createElement('input');
			    	paymentMethod.setAttribute('name', "paymentMethodId");
			    	paymentMethod.setAttribute('type', "hidden");
			    	paymentMethod.setAttribute('value', response[0].id);

			    	form.appendChild(paymentMethod);
			    } else {
			    	document.querySelector("input[name=paymentMethodId]").value = response[0].id;
			    }
			}
		};

		addEvent(document.querySelector('input[data-checkout="cardNumber"]'), 'keyup', guessingPaymentMethod);
		addEvent(document.querySelector('input[data-checkout="cardNumber"]'), 'change', guessingPaymentMethod);


		$(".coupon").keyup(function(){
			var text = this.value;
			if (text.length > 3) {
				$.get( "/get/coupon", { total:   $(this).data('total'), coupon: text } )
				.done(function( data ) {
					$(".reponse_coupon")
					.text(data.msg);
					if (data.valid) {
						$(".amount_discount")
						.html(' - descuento de' + data.amount + '<br> = '+data.total);
						$('.coupon').val(text);

					} else {
						$(".amount_discount")
						.text('');	
					}
				});

			}
		}); 
