<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;

use Onestartup\Shop\Model\CategoriaSat as Category;
use Onestartup\Shop\Model\Unidad;
use Onestartup\Shop\Model\ClavesProducto;

class CategorySatController extends Controller
{    
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        
        $categories = Category::paginate(25);

        $unidades = Unidad::select(
            \DB::raw("CONCAT(clave,'-',nombre) AS nombre"),'clave')
        ->pluck('nombre', 'clave');

        return view('shop::categorysat.index')
            ->with('categories', $categories)
            ->with('unidades', $unidades);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        
        $category = new Category($request->all());
        $category->save();

        return redirect()
            ->back()
            ->with('message_success', 'Categoria añadida correctamente');
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {   
        $category = Category::find($id);
        
        $unidades = Unidad::select(
            \DB::raw("CONCAT(clave,'-',nombre) AS nombre"),'clave')
        ->pluck('nombre', 'clave');

        return view('shop::categorysat.edit')
            ->with('category', $category)
            ->with('unidades', $unidades);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $category = Category::find($id);
        $category->fill($request->all());
        $category->save();

        return redirect()
            ->back()
            ->with('message_success', 'Categoria actualizado correctamente');
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy($id)
    {
        $category = Category::find($id);
        $category->delete();

        return redirect()
            ->back()
            ->with('message_danger', 'Categoria eliminada correctamente');
    }

    public function deleteCover($id)
    {
        $category = Category::find($id);
        $category->save();

        return redirect()
                ->back()
                ->with('message_success', 'Imagen eliminada correctamente');
    }

    public function apiClaveProd(Request $request)
    {
        $claves = ClavesProducto::where('descripcion', 'LIKE','%'.$request->q.'%')->get();
        return $claves;
    }
}
