<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;

use Onestartup\Shop\Model\DiscountCoupon as Coupon;
use Onestartup\Shop\Requests\RequestCoupon;

class DiscountCouponController extends Controller
{    
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $coupons = Coupon::paginate(25);

        return view('shop::coupon.index')
            ->with('coupons', $coupons);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(RequestCoupon $request)
    {
        $coupon = new Coupon($request->all());
        $coupon->save();

        return redirect()
            ->back()
            ->with('message_success', 'Cupon de descuento agregado correctamente');
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {   
        $coupon = Coupon::find($id);

        return view('shop::coupon.edit')
            ->with('coupon', $coupon);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(RequestCoupon $request, $id)
    {
        $coupon = Coupon::find($id);
        $coupon->fill($request->all());
        $coupon->save();

        return redirect()
            ->back()
            ->with('message_success', 'Cupon de descuento actualizado correctamente');
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy($id)
    {
        $coupon = Coupon::find($id);
        $coupon->delete();

        return redirect()
            ->back()
            ->with('message_danger', 'Cupon de descuento eliminado correctamente');
    }

}
