<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;

use Onestartup\Shop\Model\ShippingPrice as Shipping;

use Onestartup\Shop\Requests\RequestShipping;

class ShippingPriceController extends Controller
{    
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $shippings = Shipping::paginate(25);

        return view('shop::shipping.index')
            ->with('shippings', $shippings);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(RequestShipping $request)
    {
        $shipping = new Shipping($request->all());
        $shipping->save();

        return redirect()
            ->back()
            ->with('message_success', 'Forma añadida correctamente');
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {   
        $shipping = Shipping::find($id);

        return view('shop::shipping.edit')
            ->with('shipping', $shipping);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(RequestShipping $request, $id)
    {
        $shipping = Shipping::find($id);
        $shipping->fill($request->all());

        $shipping->save();

        return redirect()
            ->back()
            ->with('message_success', 'Forma actualizada correctamente');
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy($id)
    {
        $shipping = Shipping::find($id);
        $shipping->delete();

        return redirect()
            ->back()
            ->with('message_danger', 'Forma eliminada correctamente');
    }

}
