<?php

namespace Onestartup\Shop\Libs;

use Onestartup\Shop\Model\ProductShop as Product;
use Onestartup\Shop\Model\DiscountCoupon as Coupon;
use Onestartup\Shop\Notifications\StockNotify;
use App\User;

class Util
{
	
	public function countCart()
	{
		$contador = 0;

		if (\Session::has('cart')) {
			$cart = \Session::get('cart');

			foreach ($cart as $item) {
				$contador = $contador + $item->quantity;
			}
		}
		return $contador;
	}

	public function stock_change($sale, $old)
	{
		$products = $sale->products;
		$admin = User::first();

		if ($sale->status == 2) {

			foreach ($products as $product) {
				$aux = Product::find($product->id);
				
				$aux->infoSale()->decrement('quantity', $product->pivot->quantity);
				$info = $aux->infoSale;
				if ($info->quantity <= $info->reserve_amount) {
					$admin->notify(new StockNotify($product));
				}
				
			} 

		} else {

			if ($old == 2) {
				foreach ($products as $product) {
					$aux = Product::find($product->id);
					$aux->infoSale()->increment('quantity', $product->pivot->quantity);
				} 
			}

		}

	}


	public function getDiscount($sale,$code)
	{

		$client = $sale->client; 
		$addres = null;
		$cost_shipping = 0;

		if ($sale->home_delivery) {
			$addres = $client->shipping;
			$cost_shipping = $addres->shipping_price->cost;
		}
		
		$coupon = Coupon::where('code', $code)->first();
		$today = date("Y-m-d"); 
		$descuento = 0;
		$total = 0;
		$msg = 'Codigo de promoción no valido';
		$valid = false;
		$data = [];

		foreach ($sale->products as $product) {
			$aux = $product->pivot->quantity * $product->infoSale->sale_price;
			$total += $aux;
		}

		if ($coupon != null) {
			if ($today <= $coupon->expiration) {

				if ($total >= $coupon->min_sale) {

					if ($coupon->type == 'Efectivo') {
						$descuento = $coupon->value;
						$msg = 'Tienes un descuento de: '.money_format('%(#10n',$descuento);
						$valid = true;
					}

					if ($coupon->type == 'Porcentaje') {
						$descuento = ($coupon->value/100) * $total;
						$msg = 'Tienes un descuento de: '.money_format('%(#10n',$descuento);
						$valid = true;
					}

				}  else {
					$msg = 'Para aplicar este código de descuento tu compra minima debe ser de: '
					.money_format('%(#10n',$coupon->min_sale);
				}

			}  else{
				$msg = 'Lo sentimos este código de descuento ya expiró :(';
			}

		}

		$data = [
			'valid'=>$valid, 
			'msg'=>$msg, 
			'amount'=>money_format('%(#10n',$descuento), 
			'amount_unformated'=>$descuento, 
			'total'=>money_format('%(#10n', (($total+$cost_shipping)-$descuento)),
			'total_unformated'=>($total+$cost_shipping)-$descuento
		];

		return $data;
	}

}
