<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductsShopTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products_shop', function (Blueprint $table) {
            $table->increments('id');

            $table->string('name', 355);
            $table->string('slug', 455);
            $table->string('cover', 455)->nullable();
            $table->text('description')->nullable();
            $table->text('specifications')->nullable();
            $table->text('features')->nullable();
            $table->boolean('active')->default(true);
            $table->date('publication_date')->nullable();
            
            $table->string('extra1', 455)->nullable();
            $table->string('extra2', 455)->nullable();
            $table->string('extra3', 455)->nullable();
            $table->string('extra4', 455)->nullable();
            $table->string('extra5', 455)->nullable();
            $table->string('extra6', 455)->nullable();

            $table->string('extra7', 455)->nullable();
            $table->string('extra8', 455)->nullable();
            $table->string('extra9', 455)->nullable();
            $table->string('extra10', 455)->nullable();

            $table->integer('category_id')->unsigned();
            $table->foreign('category_id')
                ->references('id')
                ->on('product_categories_shop')
                ->onDelete('cascade');

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products_shop');
    }
}
