<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUuidToBillingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('billings', function (Blueprint $table) {
            $table->string('uso_cfdi')->nullable();
            $table->string('folio')->nullable();
            $table->string('uuid', 355)->nullable();
            $table->string('pdf', 355)->nullable();
            $table->string('xml', 355)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('billings', function (Blueprint $table) {
            $table->dropColumn('uso_cfdi');
            $table->dropColumn('folio');
            $table->dropColumn('uuid');
            $table->dropColumn('pdf');
            $table->dropColumn('xml');
        });
    }
}
