<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCategorySatIdToShopProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products_shop', function (Blueprint $table) {
            $table->integer('category_sat_id')->unsigned()->index()->nullable();
            $table->foreign('category_sat_id')->references('id')->on('categorias_sat')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('products_shop', function (Blueprint $table) {
            $table->dropForeign(['category_sat_id']);
            $table->dropColumn('category_sat_id');
        });
    }
}
