<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;
use Laravel\Scout\Searchable;

class ProductShop extends Model
{
    use Searchable;
    
    protected $table = 'products_shop';
    protected $fillable = [
    	'name',
		'slug',
		'description',
		'specifications',
		'features',
		'active',
        'publication_date',
		'category_id',
        'category_sat_id',
        'cover',
        'extra1',
        'extra2',
        'extra3',
        'extra4',
        'extra5',
        'extra6',
        'extra7',
        'extra8',
        'extra9',
        'extra10',


    ];

    public function category()
    {
        return $this->belongsTo('Onestartup\Shop\Model\ProductCategoryShop', 'category_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function images()
    {
        return $this->hasMany('Onestartup\Shop\Model\ProductImageShop', 'product_id');
    }

    public function infoSale()
    {
        return $this->hasOne('Onestartup\Shop\Model\ProductShopInfo', 'product_id');
    }

    public function items()
    {
        return $this->hasMany('Onestartup\Shop\Model\DetailShop', 'product_id');
    }

    public function categoria_sat()
    {
        return $this->belongsTo('Onestartup\Shop\Model\CategoriaSat', 'category_sat_id');
    }
}
