<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;

class SaleShop extends Model
{
    protected $table = 'sale_shops';
    protected $fillable = [
        'status', 
        'total', 
        'client_id', 
        'transaction_id', 
        'payment_type', 
        'shipping_status', 
        'coupon',
        'facturacion',
        'home_delivery'
    ];


    public function client()
    {
        return $this->belongsTo('Onestartup\Shop\Model\ClientShop', 'client_id');
    }

    public function items()
    {
        return $this->hasMany('Onestartup\Shop\Model\DetailShop', 'sale_id');
    }

    public function tracking_sales()
    {
        return $this->hasMany('Onestartup\Shop\Model\OrderTracking', 'sale_id');
    }

    public function products()
    {
        return $this->belongsToMany(
            'Onestartup\Shop\Model\ProductShop', 
            'detail_shops', 
            'sale_id', 
            'product_id')
                ->withPivot('quantity');
    }

    public function billing()
    {
        return $this->hasOne('Onestartup\Shop\Model\Billing', 'sale_id');
    }

    public function info_extra()
    {
        return $this->hasOne(ExtraSaleInfo::class, 'sale_id');
    }

}
