<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;

class ShippingAddres extends Model
{
    protected $table = 'shipping_addres';
    protected $fillable = [
    	'cp',
		'calle',
		'numero',
		'colonia',
		'ciudad',
		'estado',
        'referencias',
		'client_id',
        'shipping_price_id'
    ];

    public function client()
    {
        return $this->belongsTo('Onestartup\Shop\Model\ClientShop', 'client_id');
    }

    public function shipping_price()
    {
        return $this->belongsTo('Onestartup\Shop\Model\ShippingPrice', 'shipping_price_id');
    }
}
