<?php

namespace Onestartup\Shop\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Onestartup\Shop\Model\ClientShop as Client;

class PaymentClientCard extends Notification
{
    use Queueable;
    protected $tipo;
    protected $client;
    protected $status;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Client $client, $tipo, $status)
    {
        $this->tipo = $tipo;
        $this->client = $client;
        $this->status = $status;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->greeting('¡Hola!')
                    ->subject('Pago con tarjeta en '.env('APP_NAME'))
                    //->replyTo($this->interested->email, $this->interested->name)
                    ->line('Se ha generado un pago con tarjeta')
                    ->line('Tipo de tarjeta: '.$this->tipo )
                    ->line('Estatus de la transacción: '.$this->status )
                    ->line('Datos del cliente:')
                    ->line('Nombre: '.$this->client->name.' '.$this->client->lastname)
                    ->line('Telefono: '.$this->client->phone)
                    ->line('Correo: '.$this->client->email);

    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
