<?php

Route::group(['middleware' => ['web', 'auth', 'is_admin']], function(){

	Route::resource('admin/shop/product', 'Onestartup\Shop\Controller\AdminProductController', ['as'=>'admin.shop']);
	Route::resource('admin/shop/category', 'Onestartup\Shop\Controller\CategoryController', ['as'=>'admin.shop']);
	Route::resource('admin/shop/coupon', 'Onestartup\Shop\Controller\DiscountCouponController', ['as'=>'admin.shop']);
	Route::resource('admin/shop/categoriasat', 'Onestartup\Shop\Controller\CategorySatController', ['as'=>'admin.shop']);

	Route::resource('admin/shop/extra-fields', 'Onestartup\Shop\Controller\ExtraFieldController', ['as'=>'admin.shop']);

	Route::resource('admin/shop/shipping', 'Onestartup\Shop\Controller\ShippingPriceController', ['as'=>'admin.shop']);

	Route::put('admin/shop/facturar/{sale_id}', 
					'Onestartup\Shop\Controller\AdminProductController@facturar')
					->name('admin.shop.facturar');

	Route::put('admin/shop/facturaCancelar/{billing_id}', 
					'Onestartup\Shop\Controller\AdminProductController@facturaCancelar')
					->name('admin.shop.facturaCancelar');

	Route::put('admin/shop/facturaEnviar/{billing_id}', 
					'Onestartup\Shop\Controller\AdminProductController@facturaEnviar')
					->name('admin.shop.facturaEnviar');

	Route::delete('admin-shop-category/delete/cover{id}', 
				'Onestartup\Shop\Controller\CategoryController@deleteCover')
				->name('admin-shop-category.delete.cover');

	Route::get('admin-shop-product/datatable', 
				'Onestartup\Shop\Controller\AdminProductController@getProducts')
				->name('admin-shop-product.datatable');

	Route::post('admin-shop-product/{id}/store/gallery', 
				'Onestartup\Shop\Controller\AdminProductController@storeGallery')
				->name('admin-shop-product.store.gallery');

	Route::delete('admin-shop-product/delete/gallery/{id}', 
				'Onestartup\Shop\Controller\AdminProductController@deleteImage')
				->name('admin-shop-product.delete.gallery');

	Route::delete('admin-shop-product/delete/cover/{id}', 
				'Onestartup\Shop\Controller\AdminProductController@deleteCover')
				->name('admin-shop-product.delete.cover');

	/*Route::get('admin/product/variable', 
				'Onestartup\Shop\Controller\AdminProductController@showVars')
				->name('admin-shop-product.view.vars');

	Route::post('admin/product/variable', 
				'Onestartup\Shop\Controller\AdminProductController@postVars')
				->name('admin-shop-product.store.vars');*/

	Route::post('admin/shop/product-extra', 
				'Onestartup\Shop\Controller\AdminProductController@extraInfo')
				->name('admin-shop-product.extra.info');

	Route::get('admin/shop/client/list', 
				'Onestartup\Shop\Controller\AdminProductController@listClient')
				->name('admin-shop-client.list');

	Route::get('admin/shop/client/orders', 
				'Onestartup\Shop\Controller\AdminProductController@listOrders')
				->name('admin-shop-client.orders');

	Route::get('admin/shop/client/orders/{id}', 
				'Onestartup\Shop\Controller\AdminProductController@showOrder')
				->name('admin-shop-client.orders.show');

	Route::put('admin/shop/client/shipping/{id}/update', 
				'Onestartup\Shop\Controller\AdminProductController@updateShipping')
				->name('admin-shop-client.updateshipping');

	Route::put('admin/shop/client/statusSale/{id}/update', 
				'Onestartup\Shop\Controller\AdminProductController@updateStatusSale')
				->name('admin-shop-client.statussale');

	Route::post('admin/shop/client/sale/{id}/tracking', 
				'Onestartup\Shop\Controller\AdminProductController@trackingStore')
				->name('admin-shop-client.trackingStore');

	Route::get('admin/shop/stock', 
				'Onestartup\Shop\Controller\AdminProductController@stock')
				->name('admin-shop-client.stock');

	Route::put('admin/shop/refund/{sale_id}', 
				'Onestartup\Shop\Controller\AdminProductController@refund')
				->name('admin-shop-client.refund');

	Route::put('admin/shop/refundPaypal/{sale_id}', 
				'Onestartup\Shop\Controller\AdminProductController@refundPaypal')
				->name('admin-shop-client.refundPaypal');

	Route::get('api/buscar/producto', 
				'Onestartup\Shop\Controller\CategorySatController@apiClaveProd')
				->name('admin-shop-client.apiClaveProd');

	Route::get('admin/shop/config_factura', 
		'Onestartup\Shop\Controller\AdminProductController@showConfigs')
		->name('admin.shop.config_factura');

	Route::post('admin/shop/config_factura', 
		'Onestartup\Shop\Controller\AdminProductController@postConfigs')
		->name('admin.shop.config_factura.store');

	Route::get('admin/shop/variable', 'Onestartup\Shop\Controller\AdminProductController@showVars')
		->name('admin.shop.variable');

	Route::post('admin/shop/variable', 'Onestartup\Shop\Controller\AdminProductController@postVars')
		->name('admin.shop.variable.store');



});

Route::group(['middleware' => ['web']], function(){

	Route::bind('product_slug', function ($slug)
	{
		return Onestartup\Shop\Model\ProductShop::where('slug', $slug)->first();
	});

	Route::get('cart/show', 'Onestartup\Shop\Controller\CartController@show')->name('cart.show');
	Route::get('cart/add/{product_slug}', 'Onestartup\Shop\Controller\CartController@add')->name('cart.add');
	Route::get('cart/remove/{product_slug}', 'Onestartup\Shop\Controller\CartController@remove')->name('cart.remove');
	Route::get('cart/trash', 'Onestartup\Shop\Controller\CartController@trash')->name('cart.trash');
	Route::get('cart/shipping', 'Onestartup\Shop\Controller\CartController@shipping')->name('cart.shipping');
	Route::get('cart/finish', 'Onestartup\Shop\Controller\CartController@finish')->name('cart.finish');
	Route::get('cart/cancel', 'Onestartup\Shop\Controller\CartController@cancel')->name('cart.cancel');
	Route::post('cart/store/client', 'Onestartup\Shop\Controller\CartController@storeClient')->name('cart.store.client');

	Route::post('cart/payment', 'Onestartup\Shop\Controller\CartController@payment')->name('cart.payment');
	Route::post('cart/paymentCash', 'Onestartup\Shop\Controller\CartController@paymentCash')->name('cart.paymentCash');
	Route::post('cart/acordar', 'Onestartup\Shop\Controller\CartController@acordar')->name('cart.acordar');
	
	Route::get('cart/update/{product_slug}/{quantity}', 'Onestartup\Shop\Controller\CartController@update')
		->where('quantity', '[0-9]+')
		->name('cart.update');


	Route::get(env('SLUG_SHOP').'/{slug}', 'Onestartup\Shop\Controller\ProductController@show')->name('show.shop');
	Route::get(env('SLUG_SHOP'), 'Onestartup\Shop\Controller\ProductController@index')->name('main.shop');

	Route::get(env('SLUG_SHOP').'/'.env('SLUG_SHOP_CATEGORY').'/{slug_category}', 
		'Onestartup\Shop\Controller\ProductController@shoByCategory')
	->name('category.shop');
	
	
	Route::post('cart/paymentPaypal', 'Onestartup\Shop\Controller\CartController@paymentPaypal')->name('cart.paymentPaypal');
	Route::get('cart/successPaypal', 'Onestartup\Shop\Controller\CartController@successPaypal')->name('cart.successPaypal');
	Route::get('cart/cancelPaypal', 'Onestartup\Shop\Controller\CartController@cancelPaypal')->name('cart.cancelPaypal');

	Route::get('cart/testmail', 'Onestartup\Shop\Controller\CartController@testmail')->name('cart.testmail');

	Route::get('get/coupon', 'Onestartup\Shop\Controller\CartController@discount')->name('cart.discount');
	Route::get('/search', 'Onestartup\Shop\Controller\CartController@search')->name('api.search');

	Route::get('/cart/facturacion/{order_id}', 'Onestartup\Shop\Controller\CartController@facturacion')->name('cart.facturacion');

	Route::put('/cart/facturacion/{order_id}', 'Onestartup\Shop\Controller\CartController@facturacionStore')->name('facturacion.store');
});
