@section('css_extras');
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
@endsection


<div class="form-group">
	{!! Form::label('buscador', 'Buscador de claves de productos del SAT') !!}
	{!! Form::select('buscador',[], null, ["id"=>"buscador","class"=>"form-control", "placeholder"=>"Escribe aqui la clave del producto", "style"=>"width:100%"]) !!}
</div>	

<div class="form-group">
	{!! Form::label('clave_producto', 'Clave del producto *') !!}
	{!! Form::text('clave_producto', null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Selecciona una clave", "id"=>"clave_producto"]) !!}
</div>


<div class="form-group">
	{!! Form::label('clave_unidad', 'Clave Unidad *') !!}
	{!! Form::select('clave_unidad', $unidades, null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Selecciona una clave", "id"=>"nombre"]) !!}
</div>


<div class="form-group">
	{!! Form::label('unidad', 'Unidad *') !!}
	{!! Form::text('unidad', null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Selecciona una clave", "id"=>"clave", "readonly"=>"readonly"]) !!}
</div>

<div class="form-group">
	{!! Form::label('nombre', 'Nombre *') !!}
	{!! Form::text('nombre', null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Escribe el nombre de esta categoría"]) !!}
</div>


@section('script_extras')
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
<script type="text/javascript">
	$('#buscador').select2({
		placeholder: 'Busca la clave del producto aquí',
		minimumInputLength: 3,
		ajax: {
			url: '/api/buscar/producto',
			dataType: 'json',
			delay: 250,
			processResults: function (data) {
				return {
					results: $.map(data, function(obj) {
						return { id: obj.clave, text: obj.clave+' '+obj.descripcion };
					})
				};
			},
			cache: true
		}
	});

	$('#nombre').change(function(){
		var texto = $("#nombre option:selected").text();
		texto = texto.substr(texto.indexOf('-')+1); 
		$('#clave').val(texto);

	});

	$('#buscador').change(function(){
		$('#clave_producto').val(this.value);
	});

</script>

@endsection