@extends('crm-admin::main-layout')

@section('breadcrumb')
<li class="breadcrumb-item">
  <a href="{{route('home')}}">Home</a>
</li>
<li class="breadcrumb-item">
  <a href="{{route('admin-shop-client.orders')}}">Tienda</a>
</li>
<li class="breadcrumb-item active">
  Detalle orden #{{$sale->id}}
</li>
@endsection 

@section('content')
@php
setlocale(LC_MONETARY, 'en_US');
@endphp

<div class="row">
  <div class="col-md-12">

    <div class="nav-active-border b-primary">
      <ul class="nav nav-sm">
        <li class="nav-item">
          <a class="nav-link block active" href="" data-toggle="tab" data-target="#tab-1">
            <h6>Cliente</h6>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-2">
            <h6>Orden</h6>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-3">
            <h6>Envio y factura</h6>
          </a>
        </li>
        @if($variable->count() > 0)
        <li class="nav-item">
          <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-4">
            <h6>Detalles adicionales</h6>
          </a>
        </li>
        @endif
      </ul>
    </div>
    
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="tab-content pos-rlt">

      <div class="tab-pane active" id="tab-1">
        <div class="p-a-md dark _600">Datos del Cliente y seguimiento</div>
        <div class="box">
          <div class="box-body">
            <div class="row">
              <div class="col-md-6">
                <h6>Datos generales</h6>
                <p>Nombre: <b>{{$client->name}} {{$client->lastname}} </b></p>
                <p>Teléfono: <b>{{$client->phone}}</b></p>
                <p>Correo: <b>{{$client->email}}</b></p>
                <p>Fecha de registro: <b>{{$client->created_at}}</b></p>
                @if($shipping != null)
                <p>Requiere factura: <b>{{$shipping->facturacion}}</b></p>
                @endif

              </div>
              <div class="col-md-6">

                <h6>
                  Seguimiento
                  <span>
                    <a class="btn btn-xs btn-info" data-target="#add-comment" data-toggle="modal" href="javascript::void()" ui-target="#animate" ui-toggle-class="zoom">
                      Agregar seguimiento
                    </a>
                  </span>
                </h6>



                @if($sale->tracking_sales()->count() > 0)

                <ul class="timeline">
                  @foreach( $sale->tracking_sales as $comment)
                  <li class="tl-item">
                    <div class="tl-wrap b-primary">
                      <span class="tl-date text-muted">{{$comment->created_at->format('d/m/Y')}}</span>
                      <div class="tl-content box-color text-color w-xl w-auto-xs">
                        <span class="arrow b-white left pull-top"></span>
                        <div class="text-lt p-x m-b-sm">
                          {{$comment->type}}
                        </div>
                        <div class="p-a b-t b-light">
                          {{$comment->detail}}
                        </div>
                        <div class="b-t b-light">
                          <i class="fa fa-user m-l" ></i>
                          {{$comment->user->name}}
                        </div>
                      </div>
                    </div>
                  </li>
                  @endforeach
                </ul>

                @else
                <br>
                <p>No se han agregado registros</p>
                @endif


              </div>
            </div>
          </div>
          <div class='dker p-a text-right'>
            <div class='col-md-12'>

            </div>
          </div>
        </div>
      </div><!-- end tab-1 -->

      <div class="tab-pane" id="tab-2">
        <div class="p-a-md dark _600">Resumen de la Orden</div>
        <div class="box">
          <div class="box-body">
            <div class="row">

              <div class="col-md-4">
                Estatus de la compra: <a href="javascript::void()" data-target="#status_sale" data-toggle="modal" href="#" ui-target="#animate" ui-toggle-class="zoom"><i class="fa fa-edit"></i></a><br>
                <span class="label warning">{{$estado}}</span>
                <br>Medio de pago:<br>
                <b>{{$sale->payment_type}}</b>
                <br>Id Transaccion:<br>
                <b>{{$sale->transaction_id}}</b>
                <br>Fecha de orden:<br>
                <b>{{$sale->created_at}}</b>
                <br>Cupon de descuento <br>
                <b>{{$sale->coupon != null ? $sale->coupon : 'N/A'}}</b>
                <b></b>
              </div>
              <div class="col-md-8">

                <table class="table table-hover">
                  <thead>
                    <tr>
                      <th>Cantidad</th>
                      <th>Producto</th>
                      <th>Precio</th>
                      <th>Subtotal</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach($orden as $item)
                    <tr>
                      <td>{{$item->quantity}}</td>
                      <td>{{$item->product->name}}</td>
                      <td>{{money_format('%(#10n', $item->product->infoSale->sale_price)}}</td>
                      <td>{{money_format('%(#10n', ($item->product->infoSale->sale_price * $item->quantity))}}</td>
                    </tr>
                    @endforeach
                    @if($sale->coupon != null)
                    <tr>
                      <td>1</td>
                      <td>Descuento {{$sale->coupon}}</td>
                      <td> - {{$promo['amount']}}</td>
                      <td> - {{$promo['amount']}}</td>
                    </tr>
                    @endif
                    @if($shipping_price != null)
                    <tr>
                      <td>1</td>
                      <td>{{$shipping_price->name}}</td>
                      <td>{{money_format('%(#10n', $shipping_price->cost)}}</td>
                      <td>{{money_format('%(#10n', $shipping_price->cost)}}</td>
                    </tr>
                    @endif
                    <tfoot>
                      <tr>
                        <td></td>
                        <td></td>
                        <td>Total</td>
                        <td><b>{{money_format('%(#10n', $sale->total)}}</b></td>
                      </tr>
                    </tfoot>
                  </tbody>
                </table>

                @if($sale->status  == 2)
                @if($sale->payment_type == 'Tarjeta')
                {!! Form::model($sale,['route'=> ['admin-shop-client.refund', $sale->id],"method"=>"PUT", "onsubmit"=>"if(!confirm('¿Estas seguro de devolver el dinero?')){return false;}"]) !!}
                {!! Form::submit('Reembolsar efectivo a tarjeta', ['class'=>'btn btn-warning']) !!}
                {!! Form::close() !!}
                @endif

                @if($sale->payment_type  == 'Pay Pal')
                {!! Form::model($sale,['route'=> ['admin-shop-client.refundPaypal', $sale->id],"method"=>"PUT", "onsubmit"=>"if(!confirm('¿Estas seguro de devolver el dinero?')){return false;}"]) !!}
                {!! Form::submit('Reembolsar efectivo a cuenta de paypal', ['class'=>'btn btn-warning']) !!}
                {!! Form::close() !!}
                @endif

                @endif


              </div>
            </div>
          </div>
          <div class='dker p-a text-right'>
            <div class='col-md-12'>

            </div>
          </div>
        </div>
      </div><!-- end tab-2 -->

      <div class="tab-pane" id="tab-3">
        <div class="p-a-md dark _600">Direccion de Envio y estatus</div>
        <div class="box">
          <div class="box-body">
            <div class="row">

             <div class="col-md-6">
              <h4>Datos de facturación</h4>
              <p>
                ¿Requiere factura? <b>{{$sale->facturacion}}</b>
              </p>
              @if($sale->billing()->count() > 0)

              @if($sale->billing->status == 0)
              <b>Factura Pendiente</b><br>
              {!! Form::model($sale,['route'=> ['admin.shop.facturar',$sale->id],"method"=>"PUT"]) !!}
              {!! Form::submit('Crear y enviar factura', ['class'=>'btn-xs primary']) !!}
              {!! Form::close() !!}
              <br>
              @endif


              @if($sale->billing->status == 1)
              <b>Factura Enviada</b><br>
              {!! Form::model($sale->billing,['route'=> ['admin.shop.facturaEnviar',$sale->billing->id],"method"=>"PUT"]) !!}
              {!! Form::submit('Reenviar factura por correo', ['class'=>'btn-xs primary']) !!}
              {!! Form::close() !!}
              <br>

              {!! Form::model($sale->billing,['route'=> ['admin.shop.facturaCancelar',$sale->billing->id],"method"=>"PUT"]) !!}
              <button class='btn btn-xs btn-danger button-mb' onclick="return confirm('¿Estás seguro de cancelar esta factura?');" type='submit'>
                <i class='fas fa-trash-alt icon-special-size'></i>
                Cancelar factura
              </button>
              {!! Form::close() !!}
              <br>
              UUID: <b>{{$sale->billing->uuid}}</b><br>
              PDF: <a href="{{$sale->billing->pdf}}" target="blank">{{$sale->billing->pdf}}</a><br>
              XML: <a href="{{$sale->billing->xml}}" target="blank">{{$sale->billing->xml}}</a><br>
              @endif

              @if($sale->billing->status == 2)
              <b> Factura Cancelada</b><br>
              @endif

              <br>Dirección: <br>
              Calle {{$sale->billing->calle}} numero {{$sale->billing->numero}}, Col. {{$sale->billing->colonia}}
              <br>
              {{$sale->billing->ciudad}}, {{$sale->billing->estado}}. C.P. {{$sale->billing->cp}} 
              <br>
              Razón social: <b>{{$sale->billing->razon}}</b><br>
              R.F.C. <b>{{$sale->billing->rfc}}</b><br>
              Correo electrónico:<b>{{$sale->billing->correo}}</b>
              <br><br>
              <h6>Liga de formulario de facturación</h6>
              <a target="blank" href="{{route('cart.facturacion', \Crypt::encryptString($sale->id))}}">
                Visitar link
              </a>  
              @else
              <br><br>
              <h6>Liga de formulario de facturación</h6>
              <a target="blank" href="{{route('cart.facturacion', \Crypt::encryptString($sale->id))}}">
                Visitar link
              </a>
              @endif
            </div>


            <div class="col-md-6">
              @if($shipping != null)

              Direccion de entrega:<br>
              <b>{{$shipping->calle}}, # {{$shipping->numero}}, col. {{$shipping->colonia}}</b><br>
              <b>{{$shipping->ciudad}}, {{$shipping->estado}}</b><br>
              C.P. <b>{{$shipping->cp}}</b><br>
              Referencias:<br>
              <b>{{$shipping->referencias}}</b><br>

              Estatus del envio: <a href="javascript::void()" data-target="#m-a-a" data-toggle="modal" href="#" ui-target="#animate" ui-toggle-class="zoom"><i class="fa fa-edit"></i></a><br>

              <span class="label warning">{{$sale->shipping_status}}</span>
              @else
              <h6>
                No hay datos de envio, el cliente pasará a la tienda a recoger el producto
              </h6>
              @endif

            </div>


          </div>
        </div>
      </div>
    </div><!-- end tab-3 -->

    @if($variable->count() > 0)
    <div class="tab-pane" id="tab-4">
      <div class="p-a-md dark _600">Detalles adicionales</div>
      <div class="box">
        <div class="box-body">
          @if($sale->info_extra != null)
          <div class="row">
            <div class="col-md-6">
           @if($variable->alias1 != null)
            <p>
              {{$variable->alias1}} :
              <b>
                {{$sale->info_extra->extra1}}
              </b>
            </p>

           @endif

           @if($variable->alias2 != null)
            <p>
              {{$variable->alias2}} :
              <b>
                {{$sale->info_extra->extra2}}
              </b>
            </p>
           @endif

           @if($variable->alias3 != null)
           <p>
              {{$variable->alias3}} :
              <b>
                {{$sale->info_extra->extra3}}
              </b>
            </p>
           @endif

           @if($variable->alias4 != null)
           <p>
              {{$variable->alias4}} :
              <b>
                {{$sale->info_extra->extra4}}
              </b>
            </p>
           @endif

           @if($variable->alias5 != null)
            <p>
              {{$variable->alias5}} :
              <b>
                {{$sale->info_extra->extra5}}
              </b>
            </p>
           @endif

         </div>

         <div class="col-md-6">
           @if($variable->alias6 != null)
            <p>
              {{$variable->alias6}} :
              <b>
                {{$sale->info_extra->extra6}}
              </b>
            </p>
           @endif

           @if($variable->alias7 != null)
            <p>
              {{$variable->alias7}} :
              <b>
                {{$sale->info_extra->extra7}}
              </b>
            </p>
           @endif

           @if($variable->alias8 != null)
            <p>
              {{$variable->alias8}} :
              <b>
                {{$sale->info_extra->extra8}}
              </b>
            </p>
           @endif

           @if($variable->alias9 != null)
           <p>
              {{$variable->alias9}} :
              <b>
                {{$sale->info_extra->extra9}}
              </b>
            </p>
           @endif

           @if($variable->alias10 != null)
            <p>
              {{$variable->alias10}} :
              <b>
                {{$sale->info_extra->extra10}}
              </b>
            </p>
           @endif
         </div>

       </div>
       @endif

     </div>
   </div>
 </div><!-- end tab-4 -->
 @endif



</div>
</div>
</div>

<div class="modal fade animate" data-backdrop="true" id="m-a-a">
  <div class="modal-dialog" id="animate">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Cambiar estatus de envio</h5>
      </div>
      <div class="modal-body text-center p-lg">
        {!! Form::model($sale,['route'=> ['admin-shop-client.updateshipping', $sale->id],"method"=>"PUT"]) !!}

        <div class="form-group">
          {!! Form::label('shipping_status', 'Estatus del envio', ['class'=>'form-control-label']) !!}
          {!! Form::select('shipping_status', ['Pendiente'=>'Pendiente','Enviado'=>'Enviado','Cancelado'=>'Cancelado','En camino'=>'En camino'], null, ['class' => 'form-control select2', 'required'=>'required']) !!}
        </div>
        <br>
        {!! Form::submit('Actualizar', ['class'=>'btn btn-danger btn-block']) !!}
        {!! Form::close() !!}
      </div>
    </div>
  </div>
</div>

<div class="modal fade animate" data-backdrop="true" id="status_sale">
  <div class="modal-dialog" id="animate">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Cambiar estatus de compra</h5>
      </div>
      <div class="modal-body text-center p-lg">
        {!! Form::model($sale,['route'=> ['admin-shop-client.statussale', $sale->id],"method"=>"PUT"]) !!}

        <div class="form-group">
          {!! Form::label('status', 'Estatus del envio', ['class'=>'form-control-label']) !!}
          {!! Form::select('status', [0=>'Cancelado',1=>'Pendiente',2=>'Pagado',3=>'En proceso',4=>'Cancelado/Reembolsado'], null, ['class' => 'form-control select2', 'required'=>'required']) !!}
        </div>
        <br>
        {!! Form::submit('Actualizar', ['class'=>'btn btn-danger btn-block']) !!}
        {!! Form::close() !!}
      </div>
    </div>
  </div>
</div>

<div class="modal fade animate" data-backdrop="true" id="add-comment">
  <div class="modal-dialog" id="animate">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Agregar seguimiento</h5>
      </div>
      <div class="modal-body text-center p-lg">
        {!! Form::open(['route'=> ['admin-shop-client.trackingStore', $sale->id],"method"=>"POST"]) !!}

        <div class="form-group">
          {!! Form::label('type', 'Tipo', ['class'=>'form-control-label']) !!}
          {!! Form::select('type', ['Llamada'=>'Llamada','WhatsApp'=>'WhatsApp','SMS'=>'SMS','Email'=>'Email','Comentarios'=>'Comentarios'], null, ['class' => 'form-control select2', 'required'=>'required']) !!}
        </div>

        <div class="form-group">
          {!! Form::label('detail', 'Detalle', ['class'=>'form-control-label']) !!}
          {!! Form::text('detail', null, ['class' => 'form-control', 'required'=>'required']) !!}
        </div>
        <br>
        {!! Form::submit('Agregar', ['class'=>'btn btn-danger btn-block']) !!}
        {!! Form::close() !!}

      </div>
    </div>
  </div>
</div>

@endsection
