@extends('crm-admin::main-layout')
@section('breadcrumb')
  <li class="breadcrumb-item">
    <a href="{{route('home')}}">Home</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin-shop-client.orders')}}">Tienda</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin.shop.coupon.index')}}">Listado de promociones</a>
  </li>
  <li class="breadcrumb-item active">
    {{$coupon->name}}
  </li> 
@endsection
@section('content')
<div class='row'>
  <div class='col-md-12'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>Actualizar información</h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          {!! Form::model($coupon,['route'=> ['admin.shop.coupon.update',$coupon->id],"method"=>"PUT", 'enctype'=>'multipart/form-data']) !!}
          @include('shop::coupon.fields')
        </div>
      </div>
      <div class='dker p-a text-right'>
        <div class='col-md-12'>
          <a class='btn danger' href="{{route('admin.shop.coupon.index')}}">Cancelar</a>
          {!! Form::submit('Actualizar información', ['class'=>'btn dark']) !!}
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
