@php
setlocale(LC_MONETARY, 'en_US');
@endphp

@component('mail::message')

# Resumen de la compra

@component('mail::panel')
-  Numero de orden: # {{$order->id}}
-  Fecha: {{$order->created_at->format('d/m/Y')}}
-  Forma de pago: {{$order->payment_type}}
-  Cupon de descuento: {{$order->coupon != null ? $order->coupon : 'N/A'}}
@endcomponent


@component('mail::table')

| Cantidad       | Producto         | Precio  | Subtotal |
| :-------------: |:-------------:| :--------:| :-------:|
@foreach($products as $p)
| {{$p->pivot->quantity}}     | {{$p->name}}     | {{money_format('%(#10n', $p->infoSale->sale_price)}}    | {{money_format('%(#10n', $p->infoSale->sale_price * $p->pivot->quantity)}} |
@endforeach
@if($shipping != null)
| 1 | {{$shipping->shipping_price->name}}   | {{money_format('%(#10n',$shipping->shipping_price->cost)}}   | {{money_format('%(#10n',$shipping->shipping_price->cost)}} |
@endif
@if($promo != null)
| 1 | Descuento *** {{$order->coupon}} *** | {{" - ".$promo['amount']}}  | {{" - ".$promo['amount']}}| 
@endif
| - | - | Total:  | {{money_format('%(#10n',$order->total)}}| 

@endcomponent

@component('mail::panel')
Datos del comprador:

-  Nombre: *** {{$client->name}} {{$client->lastname}} ***
-  Teléfono: *** {{$client->phone}} ***
-  Correo: *** {{$client->email}} ***
@endcomponent


@component('mail::panel')
Facturación:
-  Requiere factura: *** {{$order->facturacion}} ***
@if($order->facturacion == 'Si')
[Rellenar formulario de facturación]({{route('cart.facturacion', \Crypt::encryptString($order->id))}})
@endif

@if($shipping != null)
Datos de envio:

-  Calle: *** {{$shipping->calle}} Nro. {{$shipping->numero}}, col. {{$shipping->colonia}} ***
-  *** {{$shipping->ciudad}},  {{$shipping->estado}}, C.P. {{$shipping->cp}}***
-  Referencias: *** {{$shipping->referencias}} ***
@else
Envio:

-  El cliente pasará a la tienda

@endif
@endcomponent

@if($variable != null)
@component('mail::panel')
Datos adicionales:

{{$variable->alias1 != null ? '-  '.$variable->alias1.': ' : ''}}  {{$additional->extra1 != null ? '*** '.$additional->extra1.' ***' : ''}}
{{$variable->alias2 != null ? '-  '.$variable->alias2.': ' : ''}}  {{$additional->extra2 != null ? '*** '.$additional->extra2.' ***' : ''}}
{{$variable->alias3 != null ? '-  '.$variable->alias3.': ' : ''}}  {{$additional->extra3 != null ? '*** '.$additional->extra3.' ***' : ''}}
{{$variable->alias4 != null ? '-  '.$variable->alias4.': ' : ''}}  {{$additional->extra4 != null ? '*** '.$additional->extra4.' ***' : ''}}
{{$variable->alias5 != null ? '-  '.$variable->alias5.': ' : ''}}  {{$additional->extra5 != null ? '*** '.$additional->extra5.' ***' : ''}}
{{$variable->alias6 != null ? '-  '.$variable->alias6.': ' : ''}}  {{$additional->extra6 != null ? '*** '.$additional->extra6.' ***' : ''}}
{{$variable->alias7 != null ? '-  '.$variable->alias7.': ' : ''}}  {{$additional->extra7 != null ? '*** '.$additional->extra7.' ***' : ''}}
{{$variable->alias8 != null ? '-  '.$variable->alias8.': ' : ''}}  {{$additional->extra8 != null ? '*** '.$additional->extra8.' ***' : ''}}
{{$variable->alias9 != null ? '-  '.$variable->alias9.': ' : ''}}  {{$additional->extra9 != null ? '*** '.$additional->extra9.' ***' : ''}}
{{$variable->alias10 != null ? '-  '.$variable->alias10.': ' : ''}}  {{$additional->extra10 != null ? '*** '.$additional->extra10.' ***' : ''}}

@endcomponent
@endif


Gracias por tu compra,<br>
{{ config('app.name') }}
@endcomponent
