@extends('crm-admin::main-layout')
@section('breadcrumb')
  <li class="breadcrumb-item">
    <a href="{{route('home')}}">Home</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin-shop-client.orders')}}">Tienda</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin.shop.product.index')}}">Listado de productos</a>
  </li>
  <li class="breadcrumb-item active">
    Nuevo producto
  </li> 
@endsection
@section('content')
<div class='row'>
  <div class='col-md-12'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>Agregar nuevo producto</h2>
      </div>
      <div class='box-body'>
        {!! Form::open(['route'=> 'admin.shop.product.store','method'=>'POST', "id"=>"target", 'enctype'=>'multipart/form-data']) !!}
        @include('shop::product.fields')
      </div>
      <div class='dker p-a text-right'>
        <div class='col-md-12'>
          <a class='btn danger' href="{{route('admin.shop.product.index')}}" style='margin-right:10px'>Cancelar</a>
          <button class='btn dark' type='submit'>
            Registrar
          </button>
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('script_extras')
<script src='https://cdn.ckeditor.com/4.8.0/standard/ckeditor.js'></script>
<script>
  var options = {
    filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
    filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
    filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
    filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
  };
</script>
<script>
  CKEDITOR.replace('description', options);
  CKEDITOR.replace('features', options);
  CKEDITOR.replace('specifications', options);
  $("#publication_date").datepicker({
    dateFormat: "yy-mm-dd"
  });
</script>

  @if($extras->count() > 0)

    @foreach($extras as $extra)
      @if($extra->type == 'textarea')
        <script type="text/javascript">
          CKEDITOR.replace({{$extra->variable}}, options);
        </script>
      @endif
    @endforeach

  @endif

@endsection
