@extends('crm-admin::main-layout')
@section('css_extras')
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css" rel='stylesheet' type='text/css'>
@endsection
@section('breadcrumb')
  <li class="breadcrumb-item">
    <a href="{{route('home')}}">Home</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin-shop-client.orders')}}">Tienda</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin.shop.product.index')}}">Listado de productos</a>
  </li>
  <li class="breadcrumb-item active">
    {{$product->name}}
  </li> 
@endsection
@section('content')


<div class="row">
  <div class="col-md-12">
    
      <div class="nav-active-border b-primary">
        <ul class="nav nav-sm">
          <li class="nav-item">
            <a class="nav-link block active" href="" data-toggle="tab" data-target="#tab-1">
              <h6>Información general</h6>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-2">
              <h6>Información de venta</h6>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-3">
              <h6>Galería de imagénes</h6>
            </a>
          </li>
        </ul>
      </div>
    
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="tab-content pos-rlt">

      <div class="tab-pane active" id="tab-1">
        <div class="p-a-md dark _400">Información general</div>
        <div class="box">
          <div class="box-body">
            {!! Form::model($product,['route'=> ['admin.shop.product.update', $product->id],"method"=>"PUT", 'enctype'=>'multipart/form-data']) !!}
              @include('shop::product.fields')
          </div>
          <div class='dker p-a text-right'>
            <div class='col-md-12'>
              <a class='btn danger' href="{{route('admin.shop.product.index')}}" style='margin-right:10px'>Cancelar</a>
              {!! Form::submit('Actualizar información', ['class'=>'btn dark']) !!}
              {!! Form::close() !!}
            </div>
          </div>
        </div>
      </div><!-- end tab-1 -->

      <div class="tab-pane" id="tab-2">
        <div class="p-a-md dark _600">Información de venta</div>
        <div class="box">
          <div class="box-body">
            {!! Form::model($info,['route'=> ['admin-shop-product.extra.info'],"method"=>"POST"]) !!}
              @include('shop::product.fields_extra')
          </div>
          <div class='dker p-a text-right'>
            <div class='col-md-12'>
              <a class='btn danger' href="{{route('admin.shop.product.index')}}" style='margin-right:10px'>Cancelar</a>
              {!! Form::submit('Actualizar información', ['class'=>'btn dark']) !!}
              {!! Form::close() !!}
            </div>
          </div>
        </div>
      </div><!-- end tab-2 -->

      <div class="tab-pane" id="tab-3">
        <div class="p-a-md dark _600">Galeria de imagénes</div>
        <div class="box">
          <div class="box-body">
            <div class="row">
            <div class="col-md-6">

              {!! Form::open(['route'=> ['admin-shop-product.store.gallery', $product->id], 'method' => 'POST', 'files'=>'true', 'id' => 'my-dropzone' , 'class' => 'dropzone']) !!}
              <div class="dz-message" style="height:200px;">
                Arrastra las imágenes aqui.
              </div>
              <div class="dropzone-previews"></div>
              <button type="submit" class="btn btn-success" id="submitFiles" style="display: none;">Save</button>
              {!! Form::close() !!}

            </div>
            <div class="col-md-6">
              @if($product->images->count() > 0)
              <div class="row">
                @foreach($product->images as $img)
                <div class="col-md-4">
                  <img src="{{$img->path}}" width="100%">  
                  {!! Form::open(['route'=> ['admin-shop-product.delete.gallery',$img->id],'method'=>'DELETE'])!!}
                  <button class='btn btn-danger btn-block' onclick="return confirm('¿Estás seguro de eliminar este elemento?');" type='submit'>
                    <i class='fas fa-trash-alt icon-special-size'></i>
                    Eliminar
                  </button>
                  {!! Form::close()!!}
                </div>
                @endforeach
              </div>
              @endif
            </div>

            </div>
          </div>
        </div>
      </div><!-- end tab-3 -->



    </div>
  </div>
</div>



  <!-- .modal nuevo contrato -->
  <div class='modal fade' data-backdrop='true' id='ver'>
    <div class='modal-dialog modal-lg'>
      <div class='modal-content box-shadow-z3'>
        <div class='modal-body text-center p-lg'>
          @if ($product->cover == null)
          <h4>No hay imagen asignada.</h4>
          @else
          <img class='image-modal-preview' src="{{asset('storage/'.$product->cover)}}">
          @endif
        </div>
        <div class='modal-footer'>
          <button class='btn dark p-x-md' data-dismiss='modal' type='button'>Cerrar</button>
          @if($product->cover != null)
          {!! Form::open(['route'=> ['admin-shop-product.delete.cover',$product->id],'method'=>'DELETE'])!!}
          <button class='btn btn-danger button-mb' onclick="return confirm('¿Estás seguro de eliminar este elemento?');" type='submit'>
            <i class='fas fa-trash-alt icon-special-size'></i>
            Eliminar
          </button>
          {!! Form::close()!!}
          @endif
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
  </div>

  @endsection

  @section('script_extras')
  <script src='https://cdn.ckeditor.com/4.8.0/standard/ckeditor.js'></script>
  <script>
    var options = {
      filebrowserImageBrowseUrl: '/laravel-filemanager?type=Images',
      filebrowserImageUploadUrl: '/laravel-filemanager/upload?type=Images&_token=',
      filebrowserBrowseUrl: '/laravel-filemanager?type=Files',
      filebrowserUploadUrl: '/laravel-filemanager/upload?type=Files&_token='
    };
  </script>
  <script>
    CKEDITOR.replace('description', options);
    CKEDITOR.replace('features', options);
    CKEDITOR.replace('specifications', options);
    $("#publication_date").datepicker({
      dateFormat: "yy-mm-dd"
    });
  </script>
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.js"></script>

  <script type="text/javascript">

   Dropzone.options.myDropzone = {
    autoProcessQueue: true,
    uploadMultiple: true,
    maxFilezise: 30,
    maxFiles: 10,
    parallelUploads: 10,

    init: function() {
      var submitBtn = document.querySelector("#submitFiles");
      myDropzone = this;

      submitBtn.addEventListener("click", function(e){
        e.preventDefault();
        e.stopPropagation();
        myDropzone.processQueue();
      });
      this.on("addedfile", function(file) {
                    //alert("file uploaded");
                  });

      this.on("complete", function(file) {
        myDropzone.removeFile(file);
                    //alert('que pex');
                  });

      this.on("success", function(myDropzone){

        swal({
          title: "Finalizado",
          text: "Tus imagénes subieron correctamente",
          icon: "success",
          closeOnEsc: false,
          closeOnClickOutside: false,
        }).then((value) => {
          location.reload();
        });

        myDropzone.processQueue.bind(myDropzone)

      });
    }
  };

</script>

@if($extras->count() > 0)

@foreach($extras as $extra)
@if($extra->type == 'textarea')
<script type="text/javascript">
  CKEDITOR.replace({{$extra->variable}}, options);
</script>
@endif
@endforeach

@endif

@endsection
