<div class="row">
  <div class="col-md-6">
    <div class="form-group">
      {!! Form::label('name', 'Nombre', ['class'=>'control-label'])!!}
      {!! Form::text('name', null, ["class"=>"form-control", "required"=>"required", "id"=>"first"]) !!}
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
      {!! Form::label('slug', 'URL Slug', ['class'=>'control-label'])!!}
      {!! Form::text('slug', null, ["class"=>"form-control", "required"=>"required", "id"=>"second"]) !!}
    </div>
  </div>

</div>

<div class='row'>
  <div class='col-md-6'>
    <div class="form-group" >
      {!! Form::label('active', 'Estado', ['class'=>'control-label'])!!}
      {!! Form::select('active', [true=>'Activo', false=>'Inactivo'], null, ["class"=>"form-control", "required"=>"required"]) !!}
    </div>
  </div>
  <div class='col-md-6'>
    <div class="form-group" >
      {!! Form::label('category_id', 'Categoría', ['class'=>'control-label'])!!}
      {!! Form::select('category_id', $categories, null, ["class"=>"form-control", "required"=>"required"]) !!}
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-6">
    <div class="form-group">
      {!! Form::label('cover', 'Portada', ['class'=>'control-label'])!!}
      @if (isset($product))
      <span>
        <a class="btn btn-xs accent" data-target="#ver" data-toggle="modal" href="#" ui-toggle-class="fade-up-big">
          Ver actual 
          <i class="fa fa-eye"></i>
        </a>
      </span>
      @endif
      <br>
      {!! Form::file('cover', null, ["class"=>"form-control", "required"=>"required"]) !!}
    </div>
  </div>

  <div class="col-md-6">
    <div class="form-group">
      {!! Form::label('publication_date', 'Fecha de publicación', ['class'=>'control-label'])!!}
      {!! Form::text('publication_date', isset($product) ? null: date('Y-m-d'), ["class"=>"form-control", "required"=>"required", "id"=>"publication_date"]) !!}
    </div>
  </div>

</div>

<div class="row">
  <div class="col-md-6">
    <div class="form-group" >
      {!! Form::label('category_sat_id', 'Categoría del sat', ['class'=>'control-label'])!!}
      {!! Form::select('category_sat_id', $categoria_sat, null, ["class"=>"form-control", 'placeholder'=>'Elije una categoria']) !!}
    </div>
  </div>
</div>

<div class="row">
  @if($extras->count() > 0)

  @foreach($extras as $extra)
  @if($extra->type == 'select')
  <div class="col-md-4">
    <div class="form-group">
      {!! Form::label($extra->variable, $extra->alias, ['class'=>'control-label'])!!}
      {!! Form::select($extra->variable, array_combine( explode(",", $extra->values), explode(",", $extra->values)), null, ["class"=>"form-control", "placeholder"=>"Elije una opción"]) !!}
    </div>
  </div>
  @endif

  @if($extra->type == 'text')
  <div class="col-md-4">
    <div class="form-group">
      {!! Form::label($extra->variable, $extra->alias, ['class'=>'control-label'])!!}
      {!! Form::text($extra->variable, null, ["class"=>"form-control"]) !!}
    </div>
  </div>
  @endif

  @if($extra->type == 'textarea')
  <div class="col-md-4">
    <div class="form-group">
      {!! Form::label($extra->variable, $extra->alias, ['class'=>'control-label'])!!}
      {!! Form::textarea($extra->variable, null, ["class"=>"form-control"]) !!}
    </div>
  </div>
  @endif
  @endforeach

  @endif

</div>

<div class="row">
  <div class="col-md-6">
    {!! Form::label('description', 'Descripción', ['class'=>'control-label'])!!}
    {!! Form::textarea('description', null, ["class"=>"form-control", "required"=>"required", 'id'=>'body', 'rows'=>"30", 'cols'=>"80"]) !!}
  </div>
  <div class="col-md-6">
    {!! Form::label('features', 'Características', ['class'=>'control-label'])!!}
    {!! Form::textarea('features', null, ["class"=>"form-control", "required"=>"required", 'id'=>'body', 'rows'=>"30", 'cols'=>"80"]) !!}
  </div>
</div>

<div class="row">
  <div class="col-md-6">
    {!! Form::label('specifications', 'Especificaciones', ['class'=>'control-label'])!!}
    {!! Form::textarea('specifications', null, ["class"=>"form-control", "required"=>"required", 'id'=>'body', 'rows'=>"30", 'cols'=>"80"]) !!}
  </div>
</div>


