@extends('crm-admin::main-layout')
@section('breadcrumb')
  <li class="breadcrumb-item">
    <a href="{{route('home')}}">Home</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin-shop-client.orders')}}">Tienda</a>
  </li>
  <li class="breadcrumb-item active">
    Listado de productos
  </li> 
@endsection
@section('content')
<div class='row'>
  <div class='col-md-12'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Listado de productos
          <span>
            <a class='btn btn-xs btn-info button-ml' href="{{route('admin.shop.product.create')}}">
              <i class='fas fa-plus'></i>
              Agregar producto
            </a>
          </span>
        </h2>
      </div>
      <div class='box-body'>
        <table class='table' id='products'>
          <thead>
            <tr>
              <th>#</th>
              <th>Producto</th>
              <th>Descripción</th>
              <th>Características</th>
              <th>Especificaciones</th>
              <th></th>
            </tr>
          </thead>
        </table>
      </div>
    </div>
  </div>
</div>
@endsection
@push('scripts')
<script>
    
  $(function() {
    $('#products').DataTable({
      processing: true,
      serverSide: true,
      pageLength: 25,
      ajax: '{{ route("admin-shop-product.datatable") }}',
      columns: [
            {data: 'id', name: 'id'},
            {data: 'main', name: 'main'},
            {data: 'description', name: 'description'},
            {data: 'features', name: 'features'},
            {data: 'specifications', name: 'specifications'},
            {data: 'form', name: 'form'},
        ]
    });
  
  });
</script>
@endpush




