@extends('shop-public::layout')
@section('pageTitle', 'Finalizar compra')
@section('content')

@php
setlocale(LC_MONETARY, 'en_US');
@endphp

<section>

	<h4>Detalle de la orden</h4>
	<table class="table" style="width: 60%;">
		<thead>
			<tr>
				<th>Producto</th>
				<th>Precio</th>
				<th>Cantidad</th>
				<th>Subtotal</th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			@foreach($products as $product)		

			<tr align="center">
				<td>{{$product->name}}</td>
				<td>{{money_format('%(#10n', $product->infoSale->sale_price)}}</td>
				<td>{{$product->pivot->quantity}}</td>
				<td>
					{{money_format('%(#10n', ($product->infoSale->sale_price * $product->pivot->quantity))}}
				</td>
			</tr>

			@endforeach
			@if($order->coupon != null)
			<tr align="center">
					<td>Descuento: {{$order->coupon}}</td>
					<td> - {{$data['amount']}}</td>
					<td>1</td>
					<td> - {{$data['amount']}}</td>
				</tr>
			@endif
			<tr align="center">
				<td> Envio </td>
				<td> {{$data['shipping']}} </td>
				<td> 1 </td>
				<td> {{$data['shipping']}} </td>
			</tr>
		</tbody>
		<tr>
			<td colspan="3" align="right">
				Total + Envio: 
			</td>
			<td align="center">
				{{$data['total']}}
			</td>
		</tr>
	</table>
</section>

<h4>Formulario de pago</h4>
<section>
	{!! Form::model($billing,['route'=> ['facturacion.store', $order_id],"method"=>"PUT"]) !!}
		@include('shop-public::forms.fields-facturacion')

		{!! Form::submit('Enviar información', ['class'=>'btn btn-primary']) !!}
	{!! Form::close() !!}

</section>


@endsection
