@extends('shop-public::layout')
@section('pageTitle', 'Finalizar compra')
@section('content')

@php
setlocale(LC_MONETARY, 'en_US');
@endphp

<code>
	Variables disponibles:
	<ul>
		<li>$sale</li>
		<li>$client</li>
		<li>$items</li>
		<li>$addres</li>
	</ul>
</code>

<section>

	<h4>Detalle del pedido <span><a href="{{route('cart.cancel')}}">Modificar mi carrito de compras</a></span></h4>
	<table class="table" style="width: 60%;">
		<thead>
			<tr>
				<th>Producto</th>
				<th>Precio</th>
				<th>Cantidad</th>
				<th>Subtotal</th>
				<th></th>
			</tr>
		</thead>
		@foreach($items as $item)
		<tbody>
			<tr align="center">
				<td>{{$item->product->name}}</td>
				<td>{{money_format('%(#10n', $item->product->infoSale->sale_price)}}</td>
				<td>{{$item->quantity}}</td>
				<td>
					{{money_format('%(#10n', ($item->product->infoSale->sale_price * $item->quantity))}}
				</td>
			</tr>
		</tbody>
		@endforeach
		<tr>
			<td colspan="3" align="right">
				Total + Envio: 
			</td>
			<td align="center">
				{{ money_format('%(#10n', ($total)) }} + 
				
				{{ $sale->home_delivery ? money_format('%(#10n', $addres->shipping_price->cost) : '0' }} =
				{{ $sale->home_delivery ? money_format('%(#10n', ($total + $addres->shipping_price->cost)) : money_format('%(#10n', ($total))}}
			
			</td>
		</tr>
	</table>
</section>

<section>
	<h4>Formulario de pago</h4>

	@include('shop-public::forms.fields-payment')

	<br>

	@include('shop-public::forms.fields-payment-cash')

	<br>
	@include('shop-public::forms.form-paypal')
	<br>

	<br>
	@include('shop-public::forms.form-acordar')
	<br>



</section>

@endsection

@section('scripts_extra')
<script type="text/javascript" src="{{asset('vendor/onestartup/shop/mp.js')}}"></script>
@endsection






