@extends('shop-public::layout')
@section('pageTitle', 'Finalizar compra')
@section('content')
@php
setlocale(LC_MONETARY, 'en_US');
@endphp
<code>
	Variables disponibles:
	<ul>
		<li>$shipping</li>
		<li>$total</li>
		<li>$cart</li>
	</ul>
</code>

<section>
	<h4>Detalles del pedido</h4>
	<table class="table" style="width: 60%;">
		<thead>
			<tr>
				<th>Producto</th>
				<th>Precio</th>
				<th>Cantidad</th>
				<th>Subtotal</th>
				<th></th>
			</tr>
		</thead>
		@foreach($cart as $product)
		<tbody>
			<tr align="center">
				<td>{{$product->name}}</td>
				<td>{{money_format('%(#10n', $product->infoSale->sale_price)}}</td>
				<td>{{$product->quantity}}</td>
				<td>
					{{money_format('%(#10n', ($product->infoSale->sale_price * $product->quantity))}}
				</td>
			</tr>
		</tbody>
		@endforeach
		<tr>
			<td colspan="3" align="right">
				Total: 
			</td>
			<td align="center">
				{{money_format('%(#10n', ($total))}}
			</td>
		</tr>
	</table>
</section>

<section>
	<h4>Datos del comprador</h4>
	{!! Form::model($client, ['route'=>'cart.store.client','method'=>'POST']) !!}
	@include('shop-public::forms.fields-client')
</section>

<section id="delivery" style="display: none;">
	<h4>Datos de envio</h4>
	@include('shop-public::forms.fields-shipping')
	<br>
</section>

<section>
	<h4>Información adicional</h4>
	{!! Form::hidden('additional', true) !!}
	<div class="form-group">
		{!! Form::label('extra1', 'Fecha de envío', ['class'=>'']) !!}
		{!! Form::text('extra1', null, ['class'=>'form-control', 'required'=>'required']) !!}
	</div>
	<div>
		{!! Form::label('extra2', 'Hora de envio', ['class'=>'']) !!}
		{!! Form::text('extra2', null, ['class'=>'form-control', 'required'=>'required']) !!}
	</div>
	<div>
		{!! Form::label('extra3', 'Destinatario', ['class'=>'']) !!}
		{!! Form::text('extra3', null, ['class'=>'form-control', 'required'=>'required']) !!}
	</div>
	<div>
		{!! Form::label('extra4', 'Dedicatoria', ['class'=>'']) !!}
		{!! Form::text('extra4', null, ['class'=>'form-control', 'required'=>'required']) !!}
	</div>
</section>

{!! Form::submit('Enviar información', ['class'=>'']) !!}
{!! Form::close() !!}




@endsection

@section('scripts_extra')
<script type="text/javascript">
	$('#home_delivery').change(function () {
		if ($(this).val() == 1) {
			$('#delivery').show();
			$("#delivery :input").prop('required','required');
		}  
		if ($(this).val() == 0)
		{
			$('#delivery').hide();
			$("#delivery :input").prop('required',null);
		}
	})
</script>
@endsection