<!DOCTYPE html>
<html>
<head>
	<title>
		@yield('pageTitle', '')
	</title>
	@include('shop-public::metatags')
</head>
<body>
@php
$util = new Onestartup\Shop\Libs\Util();
@endphp
	<p>
		<a href="{{route('cart.show')}}">Ver carrito 
			<span>{{$util->countCart()}} </span>
		</a>
	</p>
	{{-- Aqui toda la estructura del blog--}}

	@yield('content')

	{{-- Aqui el footer --}}

<!-- Importante: scripts elementales no remover -->
<script src='https://unpkg.com/sweetalert/dist/sweetalert.min.js'></script>
<script
  src="https://code.jquery.com/jquery-3.3.1.min.js"
  integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="
  crossorigin="anonymous"></script>

<script src="https://secure.mlstatic.com/sdk/javascript/v1/mercadopago.js"></script>

{{-- Mensajes de alerta de pagos --}}

@if(Session::has('payment_approved'))
	<script type="text/javascript">
		swal("Gracias por tu compra", "El pago ha sido aceptado, revisa tu correo", "success")
	</script>
@endif

@if(Session::has('payment_reject'))
	<script type="text/javascript">
		swal("Pago rechazado", "Tuvimos problemas para procesar tu pago, verifica tus datos o intenta con otra tarjeta", "error")
	</script>
@endif

@if(Session::has('paypal_fail'))
	<script type="text/javascript">
		swal("Pago rechazado", 
			"Tuvimos problemas para procesar tu pago, verifica tus datos : {{Session::get('paypal_fail')}}", 
			"error")
	</script>
@endif

@if(Session::has('payment_pending'))
	<script type="text/javascript">
		swal("Pago pendiente", "Estamos procesando tu pago, te notificaremos por correo el estatus", "warning")
	</script>
@endif

@if(Session::has('paypal_cancel'))
	<script type="text/javascript">
		swal("Operación cancelada", "Se cancelo el proceso de pago", "warning")
	</script>
@endif

@if(Session::has('acordar'))
	<script type="text/javascript">
		swal("Compra registrada", "Gracias! En breve nos comunicaremos contigo para cerrar la venta", "success")
	</script>
@endif

@if(Session::has('maximo'))
	<script type="text/javascript">
		swal("Problemas de existencia en inventario", 
			"Solo puedes agregar máximo  {{Session::get('maximo')}} unidades de este producto", 
			"warning")
	</script>
@endif

@if(Session::has('agotado'))
	<script type="text/javascript">
		swal("Problemas de existencia en inventario", 
			"Sentimos las inconveniencias, el producto se encuentra agotado por el momento, puedes enviarnos un correo y nosotos nos comunicaremos a la brevedad", 
			"warning")
	</script>
@endif

@if(Session::has('billing'))
	<script type="text/javascript">
		swal("Petición exitosa", 
			"Enviaremos la factura a tu correo electrónico", 
			"success")
	</script>
@endif


@if(Session::has('url_ficha'))
	<script>

		$(function() {
			var url = "{{Session::get('url_ficha')}}";
			swal("Pago pendiente", "Descarga tu ficha y llevala a pagar al lugar correspodiente", "warning")
			console.log(url);
			var biper = url.replace(/amp;/g , "");
			window.open(biper, '_blank');
		})

	</script>
@endif


<!-- ******************************************* -->


@yield('scripts_extra')


</body>
</html>