@extends('crm-admin::main-layout')
@section('breadcrumb')
  <li class="breadcrumb-item">
    <a href="{{route('home')}}">Home</a>
  </li>
  <li class="breadcrumb-item">
    <a href="{{route('admin-shop-client.orders')}}">Tienda</a>
  </li>
  <li class="breadcrumb-item active">
    Listado de formas de envío
  </li> 
@endsection
@section('content')
<div class='row'>
  <div class='col-md-12 collapse' id='agregarCategoria'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Agregar nueva forma de envío
          <span></span>
          <a aria-expanded='false' class='btn btn-xs btn-danger button-ml' data-toggle='collapse' href='#agregarCategoria'>
            Cancelar
          </a>
        </h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          {!! Form::open(['route'=> 'admin.shop.shipping.store','method'=>'POST']) !!}
          @include('shop::shipping.fields')
          <div class='form-group'>
            <button class='btn btn-primary' type='submit'>
              Registrar
            </button>
          </div>
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>
  <div class='col-md-12'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Listado de formas de envío
          <span>
            <a aria-expanded='false' class='btn btn-xs btn-info button-ml' data-toggle='collapse' href='#agregarCategoria'>
              <i class='fas fa-plus'></i>
              Agregar forma de envío
            </a>
          </span>
        </h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          <table class='table'>
            <tr>
              <th>#</th>
              <th>Nombre</th>
              <th>Costo</th>
              <th>Activo</th>
              <th></th>
            </tr>
            @foreach ($shippings as $shipping)
            <tr>
              <td> {{$shipping->id}}</td>
              <td> {{$shipping->name}} </td>
              <td> {{money_format('%(#10n', $shipping->cost)}}
              <td> {{$shipping->active ? 'Activo': 'Inactivo'}}</td>

              <td class="text-center">
                {!! Form::open(['route'=> ['admin.shop.shipping.destroy',$shipping->id],'method'=>'DELETE'])!!}
                <button class='btn btn-danger btn-xs button-mb' onclick="return confirm('¿Estás seguro de eliminar este elemento?');" type='submit'>
                  <i class='fas fa-trash-alt icon-special-size'></i>
                  Eliminar
                </button>
                {!! Form::close()!!}
                <a class='btn btn-xs accent' href="{{route('admin.shop.shipping.edit', $shipping->id)}}">
                  <i class='fas fa-edit icon-special-size'></i>
                  Editar
                </a>
              </td>
              @endforeach
            </tr>
          </table>
        </div>
      </div>
      <div class='dker p-a text-right'>
        {{ $shippings->links() }}
      </div>
    </div>
  </div>
</div>
@endsection
