<?php

namespace Onestartup\Shop\DataTables;

use Onestartup\Shop\Model\ClientShop as Client;
use Yajra\DataTables\Services\DataTable;

class ClientDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables($query);
            //->addColumn('action', function(Interested $interested) {
            //        return "<a href='".route('crm.show',$interested->id)."'>Ver Detalle</a>";
            //    });
            //->addColumn('action', 'interested.action');
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Interested $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Client $model)
    {
        return $model->select(['id','name', 'lastname','email', 'phone','created_at'])->orderBy('id', 'desc');
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->columns($this->getColumns())
                    ->parameters([
                        'dom'          => 'Bfrtip',
                        'buttons'      => ['excel', 'csv','reset', 'reload'],
                    ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'id',
            'name',
            'lastname', 
            'phone',
            'email',
            'created_at'
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'clients' . date('YmdHis');
    }
}
