<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductShopInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_shop_infos', function (Blueprint $table) {
            $table->increments('id');
            $table->string('unity', 355);
            $table->float('purchase_price')->nullable();
            $table->float('sale_price');
            $table->integer('quantity')->nullable();
            $table->integer('reserve_amount')->nullable();

            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')
                ->references('id')
                ->on('products_shop')
                ->onDelete('cascade');
                
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_shop_infos');
    }
}
