@extends('crm-admin::main-layout')

@section('content')
@php
setlocale(LC_MONETARY, 'en_US');
@endphp

<div class="row">
  <div class="col-md-12">

    <div class="nav-active-border b-primary">
      <ul class="nav nav-sm">
        <li class="nav-item">
          <a class="nav-link block active" href="" data-toggle="tab" data-target="#tab-1">
            <h6>Cliente</h6>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-2">
            <h6>Ordén</h6>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link block" href="" data-toggle="tab" data-target="#tab-3">
            <h6>Envio</h6>
          </a>
        </li>
      </ul>
    </div>
    
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="tab-content pos-rlt">

      <div class="tab-pane active" id="tab-1">
        <div class="p-a-md dark _600">Datos del Cliente y seguimiento</div>
        <div class="box">
          <div class="box-body">
            <div class="row">
              <div class="col-md-6">
                <h6>Datos generales</h6>
                <p>Nombre: <b>{{$client->name}} {{$client->lastname}} </b></p>
                <p>Teléfono: <b>{{$client->phone}}</b></p>
                <p>Correo: <b>{{$client->email}}</b></p>
                <p>Fecha de registro: <b>{{$client->created_at}}</b></p>

                <h6>Datos de facturación</h6>

              </div>
              <div class="col-md-6">

                <h6>
                  Seguimiento
                  <span>
                    <a class="btn btn-xs btn-info" data-target="#add-comment" data-toggle="modal" href="javascript::void()" ui-target="#animate" ui-toggle-class="zoom">
                      Agregar seguimiento
                    </a>
                  </span>
                </h6>



                @if($sale->tracking_sales()->count() > 0)

                <ul class="timeline">
                  @foreach( $sale->tracking_sales as $comment)
                  <li class="tl-item">
                    <div class="tl-wrap b-primary">
                      <span class="tl-date text-muted">{{$comment->created_at->format('d/m/Y')}}</span>
                      <div class="tl-content box-color text-color w-xl w-auto-xs">
                        <span class="arrow b-white left pull-top"></span>
                        <div class="text-lt p-x m-b-sm">
                          {{$comment->type}}
                        </div>
                        <div class="p-a b-t b-light">
                          {{$comment->detail}}
                        </div>
                        <div class="b-t b-light">
                          <i class="fa fa-user m-l" ></i>
                          {{$comment->user->name}}
                        </div>
                      </div>
                    </div>
                  </li>
                  @endforeach
                </ul>

                @else
                <br>
                <p>No se han agregado registros</p>
                @endif


              </div>
            </div>
          </div>
          <div class='dker p-a text-right'>
            <div class='col-md-12'>

            </div>
          </div>
        </div>
      </div><!-- end tab-1 -->

      <div class="tab-pane" id="tab-2">
        <div class="p-a-md dark _600">Resumen de la Ordén</div>
        <div class="box">
          <div class="box-body">
            <div class="row">

              <div class="col-md-4">
                Estatus de la compra: <a href="javascript::void()" data-target="#status_sale" data-toggle="modal" href="#" ui-target="#animate" ui-toggle-class="zoom"><i class="fa fa-edit"></i></a><br>
                <span class="label warning">{{$estado}}</span>
                <br>Medio de pago:<br>
                <b>{{$sale->payment_type}}</b>
                <br>Id Transaccion:<br>
                <b>{{$sale->transaction_id}}</b>
                <br>Fecha de orden:<br>
                <b>{{$sale->created_at}}</b>
              </div>
              <div class="col-md-8">

                <table class="table table-hover">
                  <thead>
                    <tr>
                      <th>Cantidad</th>
                      <th>Producto</th>
                      <th>Precio</th>
                      <th>Subtotal</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach($orden as $item)
                    <tr>
                      <td>{{$item->quantity}}</td>
                      <td>{{$item->product->name}}</td>
                      <td>{{money_format('%(#10n', $item->product->infoSale->sale_price)}}</td>
                      <td>{{money_format('%(#10n', ($item->product->infoSale->sale_price * $item->quantity))}}</td>
                    </tr>
                    @endforeach
                    <tr>
                      <td>1</td>
                      <td>{{$shipping_price->name}}</td>
                      <td>{{money_format('%(#10n', $shipping_price->cost)}}</td>
                      <td>{{money_format('%(#10n', $shipping_price->cost)}}</td>
                    </tr>
                    <tfoot>
                      <tr>
                        <td></td>
                        <td></td>
                        <td>Total</td>
                        <td><b>{{money_format('%(#10n', $sale->total)}}</b></td>
                      </tr>
                    </tfoot>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class='dker p-a text-right'>
            <div class='col-md-12'>

            </div>
          </div>
        </div>
      </div><!-- end tab-2 -->

      <div class="tab-pane" id="tab-3">
        <div class="p-a-md dark _600">Direccion de Envio y estatus</div>
        <div class="box">
          <div class="box-body">
            <div class="row">
              <div class="col-md-8 offset-2">

                Direccion de entrega:<br>
                <b>{{$shipping->calle}}, # {{$shipping->numero}}, col. {{$shipping->colonia}}</b><br>
                <b>{{$shipping->ciudad}}, {{$shipping->estado}}</b><br>
                C.P. <b>{{$shipping->cp}}</b><br>
                Referencias:<br>
                <b>{{$shipping->referencias}}</b><br>

                Estatus del envio: <a href="javascript::void()" data-target="#m-a-a" data-toggle="modal" href="#" ui-target="#animate" ui-toggle-class="zoom"><i class="fa fa-edit"></i></a><br>

                <span class="label warning">{{$sale->shipping_status}}</span>



              </div>
            </div>
          </div>
        </div>
      </div><!-- end tab-3 -->



    </div>
  </div>
</div>

<div class="modal fade animate" data-backdrop="true" id="m-a-a">
  <div class="modal-dialog" id="animate">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Cambiar estatus de envio</h5>
      </div>
      <div class="modal-body text-center p-lg">
        {!! Form::model($sale,['route'=> ['admin-shop-client.updateshipping', $sale->id],"method"=>"PUT"]) !!}

        <div class="form-group">
          {!! Form::label('shipping_status', 'Estatus del envio', ['class'=>'form-control-label']) !!}
          {!! Form::select('shipping_status', ['Pendiente'=>'Pendiente','Enviado'=>'Enviado','Cancelado'=>'Cancelado','En camino'=>'En camino'], null, ['class' => 'form-control select2', 'required'=>'required']) !!}
        </div>
        <br>
        {!! Form::submit('Actualizar', ['class'=>'btn btn-danger btn-block']) !!}
        {!! Form::close() !!}
      </div>
    </div>
  </div>
</div>

<div class="modal fade animate" data-backdrop="true" id="status_sale">
  <div class="modal-dialog" id="animate">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Cambiar estatus de compra</h5>
      </div>
      <div class="modal-body text-center p-lg">
        {!! Form::model($sale,['route'=> ['admin-shop-client.statussale', $sale->id],"method"=>"PUT"]) !!}

        <div class="form-group">
          {!! Form::label('status', 'Estatus del envio', ['class'=>'form-control-label']) !!}
          {!! Form::select('status', [0=>'Cancelado',1=>'Pendiente',2=>'Pagado',3=>'En proceso'], null, ['class' => 'form-control select2', 'required'=>'required']) !!}
        </div>
        <br>
        {!! Form::submit('Actualizar', ['class'=>'btn btn-danger btn-block']) !!}
        {!! Form::close() !!}
      </div>
    </div>
  </div>
</div>

<div class="modal fade animate" data-backdrop="true" id="add-comment">
  <div class="modal-dialog" id="animate">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Agregar seguimiento</h5>
      </div>
      <div class="modal-body text-center p-lg">
        {!! Form::open(['route'=> ['admin-shop-client.trackingStore', $sale->id],"method"=>"POST"]) !!}

        <div class="form-group">
          {!! Form::label('type', 'Tipo', ['class'=>'form-control-label']) !!}
          {!! Form::select('type', ['Llamada'=>'Llamada','WhatsApp'=>'WhatsApp','SMS'=>'SMS','Email'=>'Email','Comentarios'=>'Comentarios'], null, ['class' => 'form-control select2', 'required'=>'required']) !!}
        </div>

        <div class="form-group">
          {!! Form::label('detail', 'Detalle', ['class'=>'form-control-label']) !!}
          {!! Form::text('detail', null, ['class' => 'form-control', 'required'=>'required']) !!}
        </div>
        <br>
        {!! Form::submit('Agregar', ['class'=>'btn btn-danger btn-block']) !!}
        {!! Form::close() !!}

      </div>
    </div>
  </div>
</div>

@endsection
