@extends('shop-public::layout')
@section('pageTitle', $product->name)
@section('content')
@php
	setlocale(LC_MONETARY, 'en_US');
@endphp

<code>
	<ul>
		<li>$product</li>
		<li>$product->category->name</li>
		<li>$categories</li>
		<li>$otros</li>
	</ul>
</code>

<div style="width: 150px; margin: 5px; float: left;">
	<img src="{{asset('storage/'.$product->cover)}}" width="100%" alt="Imagen no disponible">
	<h4>{{$product->name}}</h4>
	<h4>Precio: {{money_format('%(#10n', $product->infoSale->sale_price)}}</h4>
	<div>
		<p>
			<a href="{{route('cart.add', $product->slug)}}">Agregar al carrito</a>
		</p>
		<p>
			<a href="{{route('main.shop')}}">Ver mas productos</a>
		</p>
	</div>
</div>
@endsection

