<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;
use Onestartup\Shop\Model\ProductShop as Product;
use Onestartup\Shop\Model\ProductCategoryShop as Category;
use Onestartup\Shop\Model\ShippingPrice as Shipping;
use Onestartup\Shop\Model\ClientShop as Client;
use Onestartup\Shop\Model\ShippingAddres as Addres;
use Onestartup\Shop\Model\SaleShop as Sale;
use Onestartup\Shop\Model\DetailShop as Item;
use Onestartup\Shop\Payment\MP;

class CartController extends Controller
{
   public function __construct()
   {
       if (!\Session::has('cart')) {
           \Session::put('cart', array());
       }
   }

   public function show()
   {
        $total = $this->total();
        $cart = \Session::get('cart');

        return view('shop-public::cart.show-cart')
            ->with('cart', $cart)
            ->with('total', $total);
   }

   public function add(Product $product)
   {
        $cart = \Session::get('cart');
        $quantity = 1;

        
        if (isset($cart[$product->slug])) {
            $quantity = $cart[$product->slug]->quantity + 1;
        }

        $product->quantity = $quantity;
        $cart[$product->slug] = $product;

        \Session::put('cart', $cart);

        return redirect()->route('cart.show');
   }


    public function remove(Product $product)
    {
        $cart = \Session::get('cart');

        if (!isset($cart[$product->slug])) {
            return redirect()->route('cart.show');
        }

        unset($cart[$product->slug]);
        \Session::put('cart', $cart);
        return redirect()->route('cart.show');
    }
 
    public function update(Product $product, $quantity)
    {
        if ($quantity <= 0) {
            return redirect()->back();
        }
        $cart = \Session::get('cart');
        if (!isset($cart[$product->slug])) {
            return redirect()->route('cart.show');
        }
        $cart[$product->slug]->quantity = $quantity;
        \Session::put('cart', $cart);
        return redirect()->route('cart.show');
    }

    public function trash()
    {
        
        if (\Session::has('sale')) {
            $sale = Sale::find(\Session::get('sale')->id);
            $sale->status = 0;
            $sale->save();        
        }

        \Session::forget('cart');
        \Session::forget('sale');
        \Session::forget('client');

        return redirect()->route('cart.show');
    }

    public function shipping()
    {   
        /*\Session::forget('client');
        \Session::forget('cart');
        \Session::forget('sale');*/

        $client = new Client();
        $addres = new Addres();

        if(count(\Session::get('cart')) <= 0) {return redirect()->route('cart.show');}
        if(\Session::has('client')) {
            $client = \Session::get('client');
            $addres = $client->shipping;
        }

        $cart = \Session::get('cart');
        $total = $this->total();
        $shipping = Shipping::select(
            \DB::raw("CONCAT(name,' $',cost) AS name"),'id')
            ->pluck('name', 'id');


        return view('shop-public::cart.shipping')
            ->with('cart', $cart)
            ->with('total', $total)
            ->with('client', $client)
            ->with('addres', $addres)
            ->with('shipping', $shipping);
    }

    public function storeClient(Request $request)
    {
        $client = new Client();
        $addres = new Addres();
        $cart = \Session::get('cart');

        if(\Session::has('client')) {
            $client = \Session::get('client');
            $addres = $client->shipping;
            if (\Session::get('client')->email != $request->email) {
                $client = new Client();
                $addres = new Addres();
            }
            
        }

        /** Crea cliente ········· */
        $client->fill($request->all());
        $client->save();

        /** Crea forma de envio ····· */
        $addres->fill($request->all());

        if (!isset($addres->client_id)) {
            $addres->client_id = $client->id;
        }
        
        $addres->save();

        /** Guarda productos en tabla ······ */
        $costoEnvio = $addres->shipping_price->cost;

        if (!\Session::has('sale')) {
            
            $sale = $client->sales()->save(new Sale(['status' => 1, 'total'=>($this->total() + $costoEnvio)]));

            foreach ($cart as $product) {
                $item = Item::create([
                    'product_id'=> $product->id,
                    'sale_id'=> $sale->id,
                    'quantity'=> $product->quantity
                ]);
            }

            
        } else {
            $sale = Sale::find(\Session::get('sale')->id);
            $sale->total = ($this->total() + $costoEnvio);
            $sale->save();
        }

        \Session::put('sale', $sale);
        \Session::put('client', $client);

        return redirect()->route('cart.finish');
    }

    public function finish()
    {
        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        
        return view('shop-public::cart.finish')
            ->with('sale', $sale)
            ->with('client', $client)
            ->with('items', $items)
            ->with('total', $this->total())
            ->with('addres', $addres);
    }

    public function cancel()
    {
        $sale = Sale::find(\Session::get('sale')->id);
        $sale->status = 0;
        $sale->save();

        \Session::forget('sale');

        return redirect()->route('cart.show');
        
    }

    public function payment(Request $request)
    {

        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        $detail = '';

        foreach ($sale->items as $item) {

            $detail = $detail." ".$item->quantity." ".$item->product->name.", ";
        }

        $detail = $detail." Envio ". $addres->shipping_price->name ." $". $addres->shipping_price->cost .".00";


        $mp = new MP('TEST-7957752184054483-101318-9bbc7ef53f975318d2521f05257cb66a__LB_LC__-60150825');
        $payment_data = array(
            "transaction_amount" => $this->total() + $addres->shipping_price->cost,
            "token" => $request->card_token_id,
            "description" => $detail,
            "installments" => 1,
            "payment_method_id" => $request->paymentMethodId,
            "payer" => array (
                "email" => $client->email,
                "first_name"=>$client->name,
            )
        );

        $payment = $mp->post("/v1/payments", $payment_data);

        if ($payment['response']['status'] == 'approved') {
            $sale->status = 2;
            $sale->transaction_id = $payment['response']['id'];
            $sale->save();

            \Session::forget('client');
            \Session::forget('cart');
            \Session::forget('sale');

            return redirect()
                ->route('main.shop')
                ->with('payment_approved', 'payment_approved');

        } elseif ($payment['response']['status'] == 'in_process') {

            $sale->status = 3;
            $sale->transaction_id = $payment['response']['id'];
            $sale->save();

            \Session::forget('client');
            \Session::forget('cart');
            \Session::forget('sale');

            return redirect()
                ->route('main.shop')
                ->with('payment_pending', 'payment_pending');
            
        } else {

            return redirect()
                ->back()
                ->with('payment_reject', 'payment_reject');

        }

        

        //dd($payment);

        return $request;
    }

    public function paymentCash(Request $request)
    {

        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        $detail = '';

        foreach ($sale->items as $item) {

            $detail = $detail." ".$item->quantity." ".$item->product->name.", ";
        }

        $detail = $detail." Envio ". $addres->shipping_price->name ." $". $addres->shipping_price->cost .".00";


        $mp = new MP('TEST-7957752184054483-101318-9bbc7ef53f975318d2521f05257cb66a__LB_LC__-60150825');

        $payment_data = array(
            "transaction_amount" => $this->total() + $addres->shipping_price->cost,
            
            "description" => $detail,
            
            "payment_method_id" => $request->payment_id,
            "payer" => array (
                "email" => $client->email,
                "first_name"=>$client->name,
                "last_name"=>$client->lastname
            )
        );

        $payment = $mp->post("/v1/payments", $payment_data);

        $url_ficha =  $payment['response']['transaction_details']['external_resource_url'];
        $sale->status = 3;
        $sale->transaction_id = $payment['response']['id'];
        $sale->save();

        \Session::forget('client');
        \Session::forget('cart');
        \Session::forget('sale');


        return redirect()
                ->route('main.shop')
                ->with('url_ficha', $url_ficha);


        
    }


    private function total()
    {
        $cart = \Session::get('cart');
        $total = 0;
        foreach($cart as $product){
            $total += $product->infoSale->sale_price * $product->quantity;
        }
        return $total;
    }


}
