<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;

use Onestartup\Shop\Model\ExtraField as Extra;

class ExtraFieldController extends Controller
{    
    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index()
    {
        $extras = Extra::paginate(10);
        $variables = [
            'extra1'=>'Extra 1', 
            'extra2'=>'Extra 2', 
            'extra3'=>'Extra 3', 
            'extra4'=>'Extra 4', 
            'extra5'=>'Extra 5', 
            'extra6'=>'Extra 6', 
            'extra7'=>'Extra 7', 
            'extra8'=>'Extra 8', 
            'extra9'=>'Extra 9', 
            'extra10'=>'Extra 10'
        ];

        return view('shop::extra.index')
            ->with('variables', $variables)
            ->with('extras', $extras);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        
        //$values = implode(",", $request->values);
        //return array_combine( explode(",", $values), explode(",", $values));
        
        $extra = Extra::where('variable', $request->variable)->first();

        if ($extra != null) {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('message_warning', "No se pudo agregar el registro: La variable $request->variable ya existe");
        }

        $extra = new Extra($request->all());
        if ($request->type == 'select') {
            if ($request->values != null) {
                $extra->values = implode(",", $request->values);
            } else {
                return redirect()
                    ->back()
                    ->withInput()
                    ->with('message_warning', 'No agregaste los valores para el select');
            }
            
        }
        
        
        $extra->save();

        return redirect()
            ->back()
            ->with('message_success', 'Categoria añadida correctamente');
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {   
        $extra = Extra::find($id);
        $variables = [
            'extra1'=>'Extra 1', 
            'extra2'=>'Extra 2', 
            'extra3'=>'Extra 3', 
            'extra4'=>'Extra 4', 
            'extra5'=>'Extra 5', 
            'extra6'=>'Extra 6', 
            'extra7'=>'Extra 7', 
            'extra8'=>'Extra 8', 
            'extra9'=>'Extra 9', 
            'extra10'=>'Extra 10'
        ];

        return view('shop::extra.edit')
            ->with('extra', $extra)
            ->with('variables', $variables);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $extra = Extra::find($id);
        $extra->fill($request->all());

        if ($request->type == 'select') {
            if ($request->values != null) {
                $extra->values = implode(",", $request->values);
            } else {
                return redirect()
                    ->back()
                    ->withInput()
                    ->with('message_warning', 'No agregaste los valores para el select');
            }
            
        }
        
        $extra->save();

        return redirect()
            ->back()
            ->with('message_success', 'Variable actualizado correctamente');
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy($id)
    {
        $extra = Extra::find($id);
        $extra->delete();

        return redirect()
            ->back()
            ->with('message_danger', 'Variable eliminada correctamente');
    }

    public function deleteCover($id)
    {
        $category = Category::find($id);
        $category->cover = null;
        $category->save();

        return redirect()
                ->back()
                ->with('message_success', 'Imagen eliminada correctamente');
    }
}
