<div class="form-group">
	{!! Form::label('variable', 'Variable') !!}
	{!! Form::select('variable', $variables, null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Elija una variable"]) !!}
</div>

<div class="form-group">
	{!! Form::label('alias', 'Etiqueta de la variable') !!}
	{!! Form::text('alias', null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Ej. Tipo de producto"]) !!}
</div>

<div class="form-group">
	{!! Form::label('type', 'Tipo de input') !!}
	{!! Form::select('type', ['text'=>'Texto', 'select'=>'Select', 'textarea'=>'TextArea'], null, ["class"=>"form-control", "required"=>"required", "placeholder"=>"Elija un tipo", "id"=>"type"]) !!}
</div>

<div class="form-group" id="select-values" style="display: none;">
	{!! Form::label('values', 'Valores del select: ', ['class'=>'control-label'])!!}
	{{ isset($extra->values) ? $extra->values : null }}
	{!! Form::select('values[]', [], isset($extra->values) ? explode(",",$extra->values) : null, ["id"=>"values", "multiple"=>"multiple", "style"=>"width:100%;"]) !!}
</div>

<div class="form-group">
	{!! Form::label('active', 'Estado') !!}
	{!! Form::select('active', [true=>'Activo', false=>'Inactivo'], null, ["class"=>"form-control", "required"=>"required"]) !!}
</div>

@section('script_extras')

<script>
	$(function() {
		$('#values').select2({
			tags: true
		});

		$('#type').on('change', function() {

			if (this.value == 'select') {
				$("#select-values").show();
			} else {
		  	$("#values option:selected").each(function(){
		  		$(this).remove();
		  	});
		  	$("#select-values").hide();
	  	}

		})

		if($("#type").val() == "select"){
			$("#select-values").show();
		} else {
			$("#select-values").hide();
		}

	});
</script>
@endsection