@extends('shop-public::layout')
@section('pageTitle', 'Tiendita')
@section('content')
@php
	setlocale(LC_MONETARY, 'en_US');
@endphp
<!--code>
	Variables disponibles:
	<ul>
		<li>$categories</li>
		<li>$products</li>
		<li>$otros</li>
	</ul>
</code-->

<div style="width: 100%; margin: 0 auto;">
	@foreach($products as $product)
		<div style="width: 150px; margin: 5px; float: left;">
			<img src="{{asset('storage/'.$product->cover)}}" width="100%" alt="Imagen no disponible">
			<h4>{{$product->name}}</h4>
			<h4>Precio: {{money_format('%(#10n', $product->infoSale->sale_price)}}</h4>
			<div>
				<p>
					<a href="{{route('cart.add', $product->slug)}}">Agregar al carrito</a>
				</p>
				<p>
					<a href="{{route('show.shop', $product->slug)}}">Ver mas informacion</a>
				</p>
			</div>
		</div>
	@endforeach
</div>


@endsection