<?php

namespace Onestartup\Shop\Libs;

use Onestartup\Shop\Model\ProductShop as Product;
use Onestartup\Shop\Notifications\StockNotify;
use App\User;

class Util
{
	
	public function countCart()
	{
		$contador = 0;

		if (\Session::has('cart')) {
			$cart = \Session::get('cart');

			foreach ($cart as $item) {
				$contador = $contador + $item->quantity;
			}
		}
		return $contador;
	}

	public function stock_change($sale, $old)
	{
		$products = $sale->products;
		$admin = User::first();

		if ($sale->status == 2) {

			foreach ($products as $product) {
				$aux = Product::find($product->id);
				
				$aux->infoSale()->decrement('quantity', $product->pivot->quantity);
				$info = $aux->infoSale;
				if ($info->quantity <= $info->reserve_amount) {
					$admin->notify(new StockNotify($product));
				}
				
			} 

		} else {

			if ($old == 2) {
				foreach ($products as $product) {
					$aux = Product::find($product->id);
					$aux->infoSale()->increment('quantity', $product->pivot->quantity);
				} 
			}

		}

	}

}
