<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPaymentTypeToSaleShopsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sale_shops', function (Blueprint $table) {
             $table->string('payment_type')->nullable();
             $table->string('shipping_status')->default('Pendiente');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sale_shops', function (Blueprint $table) {
            $table->dropColumn('payment_type');
            $table->dropColumn('shipping_status');
        });
    }
}
