<?php

namespace Onestartup\Shop\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Onestartup\Shop\Model\SaleShop as Order;

use Onestartup\Shop\Model\ClientShop as Client;
use Onestartup\Shop\Model\ShippingAddres as Shipping;


class ResumenOrder extends Notification
{
    use Queueable;

    protected $order;
    protected $products;
    protected $client;
    protected $shipping;

    

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Order $order, $products, Client $client, Shipping $shipping)
    {
        $this->order = $order;
        $this->products = $products;
        $this->shipping = $shipping;
        $this->client = $client;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Resumen de compra')
            ->markdown('shop::mail.resumen.order', [
                'order'=>$this->order, 
                'products'=>$this->products,
                'client'=>$this->client,
                'shipping'=>$this->shipping
            ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
