<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;
use Onestartup\Shop\Model\ProductShop as Product;
use Onestartup\Shop\Model\ProductCategoryShop as Category;
use Onestartup\Shop\Model\ShippingPrice as Shipping;
use Onestartup\Shop\Model\ClientShop as Client;
use Onestartup\Shop\Model\ShippingAddres as Addres;
use Onestartup\Shop\Model\SaleShop as Sale;
use Onestartup\Shop\Model\DetailShop as Item;
use Onestartup\Shop\Payment\MP;

use Onestartup\Shop\Notifications\PaymentClient;
use Onestartup\Shop\Notifications\PaymentClientCard;

use PayPal\Rest\ApiContext;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Api\Payer;
use PayPal\Api\Amount;
use PayPal\Api\Transaction;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Payment;
use PayPal\Api\PaymentExecution;
use PayPal\Exception\PayPalConnectionException;
use PayPal\Api\Item as PaypalItem;
use PayPal\Api\ItemList;
use PayPal\Api\Details;

class CartController extends Controller
{
   public function __construct()
   {
       if (!\Session::has('cart')) {
           \Session::put('cart', array());
       }
   }

   public function show()
   {
        $total = $this->total();
        $cart = \Session::get('cart');

        return view('shop-public::cart.show-cart')
            ->with('cart', $cart)
            ->with('total', $total);
   }

   public function add(Product $product)
   {
        $cart = \Session::get('cart');
        $quantity = 1;

        
        if (isset($cart[$product->slug])) {
            $quantity = $cart[$product->slug]->quantity + 1;
        }

        $product->quantity = $quantity;
        $cart[$product->slug] = $product;

        \Session::put('cart', $cart);

        return redirect()->route('cart.show');
   }


    public function remove(Product $product)
    {
        $cart = \Session::get('cart');

        if (!isset($cart[$product->slug])) {
            return redirect()->route('cart.show');
        }

        unset($cart[$product->slug]);
        \Session::put('cart', $cart);
        return redirect()->route('cart.show');
    }
 
    public function update(Product $product, $quantity)
    {
        if ($quantity <= 0) {
            return redirect()->back();
        }
        $cart = \Session::get('cart');
        if (!isset($cart[$product->slug])) {
            return redirect()->route('cart.show');
        }
        $cart[$product->slug]->quantity = $quantity;
        \Session::put('cart', $cart);
        return redirect()->route('cart.show');
    }

    public function trash()
    {
        
        if (\Session::has('sale')) {
            $sale = Sale::find(\Session::get('sale')->id);
            $sale->status = 0;
            $sale->save();        
        }

        \Session::forget('cart');
        \Session::forget('sale');
        \Session::forget('client');

        return redirect()->route('cart.show');
    }

    public function shipping()
    {   
        /*\Session::forget('client');
        \Session::forget('cart');
        \Session::forget('sale');*/

        $client = new Client();
        $addres = new Addres();

        if(count(\Session::get('cart')) <= 0) {return redirect()->route('cart.show');}
        if(\Session::has('client')) {
            $client = \Session::get('client');
            $addres = $client->shipping;
        }

        $cart = \Session::get('cart');
        $total = $this->total();
        $shipping = Shipping::select(
            \DB::raw("CONCAT(name,' $',cost) AS name"),'id')
            ->pluck('name', 'id');


        return view('shop-public::cart.shipping')
            ->with('cart', $cart)
            ->with('total', $total)
            ->with('client', $client)
            ->with('addres', $addres)
            ->with('shipping', $shipping);
    }

    public function storeClient(Request $request)
    {
        $client = new Client();
        $addres = new Addres();
        $cart = \Session::get('cart');

        if(\Session::has('client')) {
            $client = \Session::get('client');
            $addres = $client->shipping;
            if (\Session::get('client')->email != $request->email) {
                $client = new Client();
                $addres = new Addres();
            }
            
        }

        /** Crea cliente ········· */
        $client->fill($request->all());
        $client->save();

        /** Crea forma de envio ····· */
        $addres->fill($request->all());

        if (!isset($addres->client_id)) {
            $addres->client_id = $client->id;
        }
        
        $addres->save();

        /** Guarda productos en tabla ······ */
        $costoEnvio = $addres->shipping_price->cost;

        if (!\Session::has('sale')) {
            
            $sale = $client->sales()->save(new Sale(['status' => 1, 'total'=>($this->total() + $costoEnvio)]));

            foreach ($cart as $product) {
                $item = Item::create([
                    'product_id'=> $product->id,
                    'sale_id'=> $sale->id,
                    'quantity'=> $product->quantity
                ]);
            }

            
        } else {
            $sale = Sale::find(\Session::get('sale')->id);
            $sale->total = ($this->total() + $costoEnvio);
            $sale->save();
        }

        \Session::put('sale', $sale);
        \Session::put('client', $client);

        return redirect()->route('cart.finish');
    }

    public function finish()
    {
        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        
        return view('shop-public::cart.finish')
            ->with('sale', $sale)
            ->with('client', $client)
            ->with('items', $items)
            ->with('total', $this->total())
            ->with('addres', $addres);
    }

    public function cancel()
    {
        $sale = Sale::find(\Session::get('sale')->id);
        $sale->status = 0;
        $sale->save();

        \Session::forget('sale');

        return redirect()->route('cart.show');
        
    }

    public function payment(Request $request)
    {

        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        $detail = '';
        $status = '';
        $user = \App\User::first();

        foreach ($sale->items as $item) {

            $detail = $detail." ".$item->quantity." ".$item->product->name.", ";
        }

        $detail = $detail." Envio ". $addres->shipping_price->name ." $". $addres->shipping_price->cost .".00";


        $mp = new MP(env('AC_MERCADO_PAGO'));
        $payment_data = array(
            "transaction_amount" => $this->total() + $addres->shipping_price->cost,
            "token" => $request->card_token_id,
            "description" => $detail,
            "installments" => 1,
            "payment_method_id" => $request->paymentMethodId,
            "payer" => array (
                "email" => $client->email,
                "first_name"=>$client->name,
            )
        );

        $payment = $mp->post("/v1/payments", $payment_data);

        if ($payment['response']['status'] == 'approved') {
            $sale->status = 2;
            $sale->transaction_id = $payment['response']['id'];
            $sale->save();
            $status = 'Aprobado';

            \Session::forget('client');
            \Session::forget('cart');
            \Session::forget('sale');

            $user->notify(new PaymentClientCard($client, $request->paymentMethodId, $status));

            return redirect()
                ->route('main.shop')
                ->with('payment_approved', 'payment_approved');

        } elseif ($payment['response']['status'] == 'in_process') {

            $sale->status = 3;
            $sale->transaction_id = $payment['response']['id'];
            $sale->save();
            $status = 'En proceso';

            \Session::forget('client');
            \Session::forget('cart');
            \Session::forget('sale');

            $user->notify(new PaymentClientCard($client, $request->paymentMethodId, $status));

            return redirect()
                ->route('main.shop')
                ->with('payment_pending', 'payment_pending');
            
        } else {

            $status = 'Rechazado';

            $user->notify(new PaymentClientCard($client, $request->paymentMethodId, $status));
            return redirect()
                ->back()
                ->with('payment_reject', 'payment_reject');

        }

        
        

        

        //dd($payment);

        return $request;
    }

    public function paymentCash(Request $request)
    {

        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        $detail = '';

        foreach ($sale->items as $item) {

            $detail = $detail." ".$item->quantity." ".$item->product->name.", ";
        }

        $detail = $detail." Envio ". $addres->shipping_price->name ." $". $addres->shipping_price->cost .".00";


        $mp = new MP(env('AC_MERCADO_PAGO'));

        $payment_data = array(
            "transaction_amount" => $this->total() + $addres->shipping_price->cost,
            
            "description" => $detail,
            
            "payment_method_id" => $request->payment_id,
            "payer" => array (
                "email" => $client->email,
                "first_name"=>$client->name,
                "last_name"=>$client->lastname
            )
        );

        $payment = $mp->post("/v1/payments", $payment_data);

        $url_ficha =  $payment['response']['transaction_details']['external_resource_url'];
        $sale->status = 3;
        $sale->transaction_id = $payment['response']['id'];
        $sale->save();

        \Session::forget('client');
        \Session::forget('cart');
        \Session::forget('sale');

        $user = \App\User::first();
        $user->notify(new PaymentClient($request->payment_id, $client));


        return redirect()
                ->route('main.shop')
                ->with('url_ficha', $url_ficha);


        
    }


    private function total()
    {
        $cart = \Session::get('cart');
        $total = 0;
        foreach($cart as $product){
            $total += $product->infoSale->sale_price * $product->quantity;
        }
        return $total;
    }

    public function successPaypal(Request $request)
    {

        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $apiContext = new ApiContext(
            new OAuthTokenCredential(
                env('CLIENT_ID_PAYPAL'),    
                env('SECRET_PAYPAL')
                )
            );

        $apiContext->setConfig(
              array(
                'log.LogEnabled' => true,
                'log.FileName' => base_path().'/Paypal.log',
                'log.LogLevel' => 'DEBUG',
                'mode' => env('PAYPAL_MODE'),
              )
        );


        $paymentId = $request->paymentId;
        $payment = Payment::get($paymentId, $apiContext);
        $execution = new PaymentExecution();
        $execution->setPayerId($request->PayerID);

        try {

            $result = $payment->execute($execution, $apiContext);

            if ($result->state == 'approved') {
                
                $sale = Sale::find(\Session::get('sale')->id);
                $client = $sale->client;
                $items = $sale->items;
                $addres = $client->shipping;

                $sale->status = 2;
                $sale->save();

                $user = \App\User::first();
                $user->notify(new PaymentClientCard($client, 'Paypal', 'Pagado'));

                \Session::forget('client');
                \Session::forget('cart');
                \Session::forget('sale');

                return redirect()
                        ->route('main.shop')
                        ->with('payment_approved', 'payment_approved');
            } else {
                return redirect()
                    ->route('cart.finish')
                    ->with('paypal_fail',$result->state);
            }

        } catch (\PayPal\Exception\PayPalConnectionException $ex) {
            return $ex->getData();
        }



    }

    public function cancelPaypal()
    {
        return redirect()
            ->route('cart.show')
            ->with('paypal_cancel', 'paypal_cancel');
    }

    public function paymentPaypal(Request $request)
    {

        if (!\Session::has('client')) {
            return redirect()->route('cart.shipping');   
        }

        if (!\Session::has('sale')) {
            return redirect()->route('cart.shipping');
        }

        $sale = Sale::find(\Session::get('sale')->id);
        $client = $sale->client;
        $items = $sale->items;
        $addres = $client->shipping;
        $detail = '';

        

        $apiContext = new ApiContext(
            new OAuthTokenCredential(
                env('CLIENT_ID_PAYPAL'),    
                env('SECRET_PAYPAL')
                )
            );

        $apiContext->setConfig(
              array(
                'log.LogEnabled' => true,
                'log.FileName' => base_path().'/Paypal.log',
                'log.LogLevel' => 'DEBUG',
                'mode' => env('PAYPAL_MODE'),
              )
        );

        

        $payer = new \PayPal\Api\Payer();
        $payer->setPaymentMethod('paypal');
        $items = array();


        foreach ($sale->items as $item) {
            //$cost = $item->product->infoSale->sale_price * $item->quantity;
            
            $item1 = new PaypalItem();
            $item1->setName($item->product->name)
                ->setDescription($item->product->name)
                ->setCurrency('MXN')
                ->setQuantity($item->quantity)
                ->setPrice($item->product->infoSale->sale_price);

            $items[]=$item1;
        }

        $item2 = new PaypalItem();
        $item2->setName($addres->shipping_price->name)
            ->setDescription($addres->shipping_price->name)
            ->setCurrency('MXN')
            ->setQuantity(1)
            ->setPrice($addres->shipping_price->cost);

        array_push($items, $item2);
        

        $itemList = new ItemList();
        $itemList->setItems($items);

        $details = new Details();
        $details->setSubtotal($this->total() + $addres->shipping_price->cost);

        
        $amount = new \PayPal\Api\Amount();
        $amount->setCurrency("MXN")
                ->setTotal($this->total() + $addres->shipping_price->cost)
                ->setDetails($details);
        


        $transaction = new \PayPal\Api\Transaction();
        $transaction->setAmount($amount)
            ->setItemList($itemList)
            ->setDescription("Compra en Onestartup")
            ->setInvoiceNumber(uniqid());


        $redirectUrls = new \PayPal\Api\RedirectUrls();
        $redirectUrls->setReturnUrl(route('cart.successPaypal'))
            ->setCancelUrl(route('cart.cancelPaypal'));

        $payment = new \PayPal\Api\Payment();
        $payment->setIntent('sale')
            ->setPayer($payer)
            ->setRedirectUrls($redirectUrls)
            ->setTransactions(array($transaction));

        try {
            $payment->create($apiContext);
            $sale->status = 3;
            $sale->transaction_id = $payment->id;
            $sale->save();
            
            return redirect($payment->getApprovalLink());
            
        }
        catch (\PayPal\Exception\PayPalConnectionException $ex) {
            echo $ex->getData();
        }
    }


}
