<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;

class SaleShop extends Model
{
    protected $table = 'sale_shops';
    protected $fillable = ['status', 'total', 'client_id', 'transaction_id'];


    public function client()
    {
        return $this->belongsTo('Onestartup\Shop\Model\ClientShop', 'client_id');
    }

    public function items()
    {
        return $this->hasMany('Onestartup\Shop\Model\DetailShop', 'sale_id');
    }
}
