@extends('shop-public::layout')
@section('pageTitle', 'Carrito')
@section('content')
@php
setlocale(LC_MONETARY, 'en_US');
@endphp
<!--code>
	Variables disponibles:
	<ul>
		<li>$cart</li>
		<li>$total</li>
	</ul>
</code-->

<div style="width: 50%; margin: 0 auto;">
	@if(count($cart))
	<div class="cart">
		<table class="table" style="width: 100%;" align="right">
			<thead>
				<tr>
					<th>Producto</th>
					<th>Precio</th>
					<th>Cantidad</th>
					<th>Subtotal</th>
					<th></th>
				</tr>
			</thead>
			@foreach($cart as $product)
			<tbody>
				<tr>
					<td>{{$product->name}}</td>
					<td>{{money_format('%(#10n', $product->infoSale->sale_price)}}</td>
					<td>
						<input 
						type="number" 
						min="1" 
						value="{{$product->quantity}}" 
						id="product-{{$product->slug}}">
						<a 
						href="#" 
						class="btn-update"
						data-href="{{ route('cart.update', [$product->slug,'']) }}"
						data-slug = "{{ $product->slug }}">
						Cambiar
					</a>
				</td>
				<td>{{money_format('%(#10n', ($product->infoSale->sale_price * $product->quantity))}}</td>
				<td>
					<p>
						<a href="{{route('show.shop', $product->slug)}}">Detalle</a>
					</p>
					<p>
						<a href="{{route('cart.remove', $product->slug)}}">Eliminar</a>
					</p>
				</td>
			</tr>
		</tbody>
		@endforeach
		<tr>
			<td colspan="4" align="right">
				{{money_format('%(#10n', ($total))}}
			</td>
		</tr>
	</table>
	<p>
		<a href="{{route('cart.trash')}}">
			Vaciar carrito de compras
		</a>
	</p>
	<p>
		<a href="{{route('main.shop')}}">Ver mas productos</a>
	</p>
	<p>
		<a href="{{route('cart.shipping')}}">Finalizar compra</a>
	</p>

</div>
@else
<h1>No hay productos agregados</h1>
<p>
		<a href="{{route('main.shop')}}">Visitar productos</a>
</p>
@endif
</div>


@endsection

@section('scripts_extra')
<script type="text/javascript">
	// Update item cart
	$(".btn-update").on('click', function(e){
		e.preventDefault();
		var slug = $(this).data('slug');
		var href = $(this).data('href');
		var quantity = $("#product-" + slug).val();
		window.location.href = href + "/" + quantity;
	});
</script>
@endsection