<?php

namespace Onestartup\Shop\Controller;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;
use Onestartup\Shop\Model\ProductCategoryShop as Category;
use Onestartup\Shop\Model\ProductImageShop as Gallery;
use Onestartup\Shop\Model\ProductShop as Product;
use Onestartup\Shop\Model\ExtraField as Extra;
use Onestartup\Shop\Model\ProductShopInfo as ProductInfo;

use Onestartup\Shop\DataTables\ClientDataTable;
use Onestartup\Shop\DataTables\OrderDataTable;
use Onestartup\Shop\DataTables\StockDataTable;

use Onestartup\Shop\Model\SaleShop as Sale;
use Onestartup\Shop\Model\OrderTracking as Tracking;
use Onestartup\Shop\Libs\Util;

class AdminProductController extends Controller
{
    protected $util;

    public function __construct()
    {
        $this->util = new Util();
    }

    public function index()
    {
        return view('shop::product.index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        $categories = Category::pluck('name', 'id');
        $extras = Extra::where('active', true)->orderBy('variable', 'asc')->get();

        return view('shop::product.create')
        ->with('categories', $categories)
        ->with('extras', $extras);
    }

    /**
     * Store a newly created resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function store(Request $request)
    {

        $product = new Product($request->all());

        if (isset($request->cover)) {

            $file = $request->file('cover');
            $nombre = $file->getClientOriginalName();
            $nombre_file = str_replace(' ', '_', $nombre);
            $ubicacion_donde_guarda ='shop/products/cover/'.$nombre_file;
            \Storage::disk('local')->put($ubicacion_donde_guarda,  \File::get($file));
            $product->cover = $ubicacion_donde_guarda;
        } 


        \Auth::user()->productsShop()->save($product);
        

        return redirect()
        ->route('admin.shop.product.edit', $product->id)
        ->with('message_success', "Producto guardado correctamente, continua agregando las imagenes correspondientes");
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {
        $product = Product::find($id);
        $categories = Category::pluck('name', 'id');
        $extras = Extra::where('active', true)->orderBy('variable', 'asc')->get();

        if ($product->infoSale != null) {
            $info = $product->infoSale;
        } else {
            $info = new ProductInfo();
        }

        //return $info;


        return view('shop::product.edit')
        ->with('categories', $categories)
        ->with('product', $product)
        ->with('info', $info)
        ->with('extras', $extras);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request $request, $id)
    {
        $product = Product::find($id);
        $product->fill($request->all());

        if (isset($request->cover)) {

            $file = $request->file('cover');
            $nombre = $file->getClientOriginalName();
            $nombre_file = str_replace(' ', '_', $nombre);
            $ubicacion_donde_guarda ='shop/products/cover/'.$nombre_file;
            \Storage::disk('local')->put($ubicacion_donde_guarda,  \File::get($file));
            $product->cover = $ubicacion_donde_guarda;
        } 


        $product->save();

        return redirect()
        ->back()
        ->with('message_info', 'Información actualizada correctamente');
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy($id)
    {
        $product = Product::find($id);
        $product->delete();

        return redirect()
        ->back()
        ->with('message_danger', 'Producto eliminada correctamente');
    }

    public function getProducts()
    {

        $products = Product::select([
            'id',
            'name',
            'slug', 
            'category_id', 
            'created_at', 
            'description', 
            'features', 
            'specifications'
        ]);

        return Datatables::of($products)
        ->addColumn('main', function ($product) {
            return 
            "<p class='mb0'>Nombre: <b>$product->name</b></p>".
            "<p class='mb0'>Slug: <b>$product->slug</b></p>".
            "<p class='mb0'>Categoria: <b>".$product->category->name."</b></p>".
            "<p class='mb0'>Fecha creación: <b>".$product->created_at->format('d/m/Y')."</b></p>";
        })
        ->addColumn('form', function ($product) {
            return "<form method='POST' action='".route('admin.shop.product.destroy',$product->id)."'>".
            "<input name='_method' type='hidden' value='DELETE' class='has-value'>".
            csrf_field() .
            "<button class='btn btn-danger btn-xs button-mb' onclick='return confirm();' type='submit'>".
            "<i class='fas fa-trash-alt icon-special-size'></i>Eliminar</button>".
            "</form>".
            "<a href='".route('show.shop', $product->slug)."' class='btn btn-xs info button-mb' target='new'>".
            "<i class='fas fa-eye icon-special-size'></i>Ver</a>".
            "<br><a href='".route('admin.shop.product.edit', $product->id)."' class='btn btn-xs accent mb0'>".
            "<i class='fas fa-edit icon-special-size'></i>Editar</a>";
        })
        ->rawColumns(['main', 'description', 'features', 'specifications', 'form'])
        ->make();
        
    }

    public function storeGallery(Request $request, $product_id)
    {
        $product = Product::find($product_id);

        $asset = '/storage/shop/product/'.$product->id.'/gallery/';
        $path = public_path().$asset;
        $files = $request->file('file');

        foreach($files as $file){
            $fileName = $file->getClientOriginalName();
            $nombre_file = str_replace(' ', '_', $fileName);
            $file->move($path, $nombre_file);
            $gallery = new Gallery([
                'path'=>$asset.$nombre_file
            ]);

            $product->images()->save($gallery);
        }


        return $product;
    }

    public function deleteImage($id)
    {
        $gallery = Gallery::find($id);
        if (file_exists(public_path().$gallery->path)) {
            unlink(public_path().$gallery->path);
        }
        
        $gallery->delete();

        return redirect()
        ->back()
        ->with('message_danger', 'Imagen eliminada correctamente');

    }

    public function deleteCover($id)
    {
        $product = Product::find($id);
        if (file_exists(public_path().'/storage/'.$product->cover)) {
            unlink(public_path().'/storage/'.$product->cover);
        }
        
        $product->cover = null;
        $product->save();

        
        //$gallery->delete();

        return redirect()
        ->back()
        ->with('message_danger', 'Imagen eliminada correctamente');

    }



    public function extraInfo(Request $request)
    {

        $info = ProductInfo::find($request->product_id);

        if ($info == null) {
            $info = new ProductInfo();
        }

        $info->fill($request->all());

        $info->save();

        return redirect()
        ->back()
        ->with('message_success', 'Información de venta actualizada');

    }

    public function listClient(ClientDataTable $dataTable)
    {
        return $dataTable->render('shop::clients.list');
    }

    public function listOrders(OrderDataTable $dataTable)
    {
        return $dataTable->render('shop::clients.orders');
    }

    public function stock(StockDataTable $dataTable)
    {
        return $dataTable->render('shop::product.stock');
    }

    public function showOrder($id)
    {
        $sale = Sale::find($id);
        $client = $sale->client;
        $orden = $sale->items;
        $shipping = $client->shipping;
        $shipping_price = $shipping->shipping_price;

        if ($sale->status == 0) {
            $estado = "Cancelado";
        }

        if ($sale->status == 1) {
            $estado = "Pendiente";
        }

        if ($sale->status == 2) {
            $estado = "Pagado";
        }

        if ($sale->status == 3) {
            $estado = "En proceso";
        }

        return view('shop::clients.orden')
        ->with('sale', $sale)
        ->with('client', $client)
        ->with('orden', $orden)
        ->with('estado', $estado)
        ->with('shipping_price', $shipping_price)
        ->with('shipping', $shipping);
    }

    public function updateShipping(Request $request, $id)
    {
        $sale = Sale::find($id);
        $sale->shipping_status = $request->shipping_status;
        $sale->save();

        return redirect()->back()->with('message_success', 'Estatus actualizado correctamente');
    }

    public function updateStatusSale(Request $request, $id)
    {
        $sale = Sale::find($id);
        $old = $sale->status;
        $sale->status = $request->status;
        $sale->save();

        $this->util->stock_change($sale, $old);

        return redirect()->back()->with('message_success', 'Estatus actualizado correctamente');
    }

    public function trackingStore(Request $request, $id)
    {
        $sale = Sale::find($id);
        $comment = new Tracking($request->all());
        $comment->user_id = \Auth::user()->id;

        $sale->tracking_sales()->save($comment);

        return redirect()
            ->back()
            ->with('message_success', 'Información agregada correctamente');
    }

}
