<?php

namespace Onestartup\Shop\DataTables;

use Onestartup\Shop\Model\SaleShop as Sale;
use Yajra\DataTables\Services\DataTable;

class OrderDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables($query)
            ->addColumn('cliente', function(Sale $sale) {
                    return 'Nombre: <b>'.$sale->client->name." ".$sale->client->lastname.'</b>'.
                            '<br>Teléfono: <b>'.$sale->client->phone.'</b>'.
                            '<br>Correo: <b>'.$sale->client->email.'</b>';
                })
            ->addColumn('orden', function(Sale $sale) {
                    $estado = "";
                    $html = "";
                    if ($sale->status == 0) {
                        $estado = "<span class='label danger'>Cancelado</span>";
                    }

                    if ($sale->status == 1) {
                        $estado = "<span class='label warning'>Pendiente</span>";
                    }

                    if ($sale->status == 2) {
                        $estado = "<span class='label success'>Pagado</span>";
                    }

                    if ($sale->status == 3) {
                        $estado = "<span class='label primary'>En proceso</span>";
                    }
                    $html = "Estado: <b>$estado</b><br>Tipo: <b>$sale->payment_type</b> <br>Transaccion:<br><b>$sale->transaction_id</b><br>Envio: <b>".$sale->client->shipping->shipping_price->name."</b>";
                    return $html;
                })
            ->addColumn('action',  function (Sale $sale){
                return "<a href='".route('admin-shop-client.orders.show',$sale->id)."'>Ver Detalle</a>";
            })
            ->rawColumns(['orden', 'action', 'cliente']);
            
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Interested $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Sale $model)
    {
        return $model->select(['id', 'client_id', 'status', 'payment_type','transaction_id', 'total', 'created_at'])->where('status', '!=', 0)->orderBy('id', 'desc');
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->columns($this->getColumns())
                    ->parameters([
                        'dom'          => 'Bfrtip',
                        'pageLength'   => 20,
                        'buttons'      => ['excel', 'csv','reset', 'reload'],
                    ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'id', 
            'cliente', 
            'orden', 
            'created_at',
            'action'
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'orders' . date('YmdHis');
    }
}
