<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class ClientShop extends Model
{
    use Notifiable;

    protected $table = 'client_shops';
    protected $fillable = [
    	'name',
		'lastname',
		'email',
		'phone'
	];

	public function shipping()
    {
        return $this->hasOne('Onestartup\Shop\Model\ShippingAddres', 'client_id');
    }

    public function sales()
    {
        return $this->hasMany('Onestartup\Shop\Model\SaleShop', 'client_id');
    }
    
}
