<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;

class DetailShop extends Model
{
    protected $table = "detail_shops";
    protected $fillable = ['product_id', 'sale_id', 'quantity'];

    public function sale()
    {
        return $this->belongsTo('Onestartup\Shop\Model\SaleShop', 'sale_id');
    }

    public function product()
    {
        return $this->belongsTo('Onestartup\Shop\Model\ProductShop', 'product_id');
    }
}
